/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class DWHealthIndicatorWrapper
implements HealthIndicator {
    private static Log log = LogFactory.getLog(DWHealthIndicatorWrapper.class);
    private HealthIndicator source;

    public DWHealthIndicatorWrapper(HealthIndicator source) {
        this.source = source;
    }

    public HealthIndicator getSource() {
        return this.source;
    }

    public Health health() {
        return DWHealthIndicatorWrapper.executeHealthAndAttachDurationInfo(() -> ((HealthIndicator)this.source).health());
    }

    protected static Health executeHealthAndAttachDurationInfo(Supplier<Health> healthSupplier) {
        long start = System.currentTimeMillis();
        Health health = healthSupplier.get();
        long finish = System.currentTimeMillis();
        long duration = finish - start;
        String formattedDuration = String.format("%d.%03d second(s)", duration / 1000L, duration % 1000L);
        Map detailsMap = health.getDetails();
        LinkedHashMap<String, String> customMap = new LinkedHashMap<String, String>();
        customMap.put("dw-duration", formattedDuration);
        customMap.putAll(detailsMap);
        try {
            Field detailsField = Health.class.getDeclaredField("details");
            detailsField.setAccessible(true);
            detailsField.set(health, customMap);
        }
        catch (Exception e) {
            log.error((Object)"DWHealthIndicatorAdapter health method failed!", (Throwable)e);
        }
        return health;
    }
}

