/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import com.digiwin.app.actuate.DWHealthIndicatorWrapper;
import com.digiwin.app.actuate.DWReactiveHealthIndicatorWrapper;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;

public class DWWrapHealthIndicatorBeanPostProcessor
implements BeanPostProcessor {
    private static Log log = LogFactory.getLog(DWWrapHealthIndicatorBeanPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HealthContributor) {
            String string = bean.getClass().getName();
        }
        if (bean instanceof CompositeHealthContributor) {
            this.wrapInnerHealthIndicator(beanName, (CompositeHealthContributor)bean);
        } else {
            if (bean instanceof HealthIndicator && !(bean instanceof DWHealthIndicatorWrapper)) {
                log.debug((Object)String.format("wrap HealthIndicator(beanName=%s, class=%s)", bean, bean.getClass().getName()));
                return new DWHealthIndicatorWrapper((HealthIndicator)bean);
            }
            if (bean instanceof ReactiveHealthIndicator && !(bean instanceof DWReactiveHealthIndicatorWrapper)) {
                log.debug((Object)String.format("wrap ReactiveHealthIndicator(beanName=%s, class=%s)", bean, bean.getClass().getName()));
                return new DWReactiveHealthIndicatorWrapper((ReactiveHealthIndicator)bean);
            }
        }
        return bean;
    }

    private void wrapInnerHealthIndicator(String beanName, CompositeHealthContributor compositeHealthContributor) {
        log.debug((Object)String.format("wrap CompositeHealthContributor(beanName=%s, className=%s) inner indicators...", beanName, compositeHealthContributor.getClass().getSimpleName()));
        try {
            Field indicatorsField = compositeHealthContributor.getClass().getSuperclass().getDeclaredField("map");
            indicatorsField.setAccessible(true);
            LinkedHashMap wrappedMap = new LinkedHashMap();
            Map innerIndicators = (Map)indicatorsField.get(compositeHealthContributor);
            for (Map.Entry entry : innerIndicators.entrySet()) {
                HealthIndicator healthIndicator = (HealthIndicator)entry.getValue();
                if (!(healthIndicator instanceof DWHealthIndicatorWrapper)) {
                    log.debug((Object)String.format("wrap CompositeHealthContributor(field=%s) inner indicator(key=%s, class=%s)", indicatorsField.getName(), entry.getKey(), ((HealthIndicator)entry.getValue()).getClass().getName()));
                    healthIndicator = new DWHealthIndicatorWrapper(healthIndicator);
                }
                wrappedMap.put(entry.getKey(), healthIndicator);
            }
            indicatorsField.set(compositeHealthContributor, wrappedMap);
            log.debug((Object)String.format("wrap CompositeHealthContributor inner indicators completed!", beanName));
        }
        catch (Exception e) {
            log.warn((Object)String.format("CompositeHealthContributor(class=%s) failed!", compositeHealthContributor.getClass().getName()), (Throwable)e);
        }
    }
}

