/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.metrics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;

public abstract class DWAbstractModuleBeanMetricsProcessor<T> {
    private Class<T> targetBeanType;

    public DWAbstractModuleBeanMetricsProcessor() {
        Type[] parameterizedType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.targetBeanType = (Class)parameterizedType[0];
    }

    public boolean accept(Object bean) {
        return this.targetBeanType.isAssignableFrom(bean.getClass());
    }

    public void process(String moudleName, String beanName, T bean) {
        Object originalBean = this.getRealBean(bean);
        this.putModuleTagName(moudleName, beanName, originalBean);
        this.registryMerer(moudleName, beanName, originalBean);
    }

    public abstract void registryMerer(String var1, String var2, T var3);

    public abstract Map<Object, String> getBeanMapTagMap();

    public void putModuleTagName(String moudleName, String beanName, T bean) {
        if (!this.getBeanMapTagMap().containsKey(bean)) {
            String tagValue = String.format("[%s].%s", moudleName, beanName);
            this.getBeanMapTagMap().put(bean, tagValue);
        }
    }

    public Object getRealBean(Object bean) {
        return AopUtils.isAopProxy((Object)bean) ? AopProxyUtils.getSingletonTarget((Object)bean) : bean;
    }
}

