/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import com.mongodb.event.ConnectionAddedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionRemovedEvent;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DWMongoListenerMetrics
implements CommandListener,
ConnectionPoolListener {
    private final String METRICS_EXECUTE = "dwmongodb.execute";
    private final String METRICS_POOL_ACTIVE = "dwmongodb.pool.active";
    private final String METRICS_POOL_MAX = "dwmongodb.pool.maxSize";
    private final String METRICS_POOL_MIN = "dwmongodb.pool.minSize";
    MeterRegistry registry;
    private static Map<String, AtomicInteger> activeCountMap = new ConcurrentHashMap<String, AtomicInteger>();

    public DWMongoListenerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        Timer.builder((String)"dwmongodb.execute").tag("clusterId", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).register(this.registry).record(event.getElapsedTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public void commandFailed(CommandFailedEvent event) {
        Timer.builder((String)"dwmongodb.execute").tag("clusterId", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).register(this.registry).record(event.getElapsedTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        String clusterId = event.getServerId().getClusterId().getValue();
        this.getCounterByClusterId(clusterId).set(event.getSettings().getMinSize());
        Gauge.builder((String)"dwmongodb.pool.maxSize", (Object)"dwmongodb.pool.maxSize", s -> event.getSettings().getMaxSize()).tag("clusterId", clusterId).register(this.registry);
        Gauge.builder((String)"dwmongodb.pool.minSize", (Object)"dwmongodb.pool.minSize", s -> event.getSettings().getMinSize()).tag("clusterId", clusterId).register(this.registry);
        this.registryMongoActive(clusterId);
    }

    public void connectionAdded(ConnectionAddedEvent event) {
        String clusterId = event.getConnectionId().getServerId().getClusterId().getValue();
        this.getCounterByClusterId(clusterId).incrementAndGet();
        this.registryMongoActive(clusterId);
    }

    public void connectionRemoved(ConnectionRemovedEvent event) {
        String clusterId = event.getConnectionId().getServerId().getClusterId().getValue();
        this.getCounterByClusterId(clusterId).decrementAndGet();
        this.registryMongoActive(clusterId);
    }

    private void registryMongoActive(String clusterId) {
        Gauge.builder((String)"dwmongodb.pool.active", (Object)"METRICS_POOL_ACTIVE", s -> this.getCounterByClusterId(clusterId).get()).tag("clusterId", clusterId).register(this.registry);
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        String clusterId = event.getConnectionId().getServerId().getClusterId().getValue();
        this.getCounterByClusterId(clusterId).incrementAndGet();
        this.registryMongoActive(clusterId);
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        String clusterId = event.getConnectionId().getServerId().getClusterId().getValue();
        this.getCounterByClusterId(clusterId).decrementAndGet();
        this.registryMongoActive(clusterId);
    }

    public void commandStarted(CommandStartedEvent event) {
    }

    private AtomicInteger getCounterByClusterId(String clusterId) {
        if (!activeCountMap.containsKey(clusterId)) {
            activeCountMap.put(clusterId, new AtomicInteger(0));
        }
        return activeCountMap.get(clusterId);
    }
}

