/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import com.digiwin.app.actuate.DWAbstractModuleBeanHealthIndicatorProcessor;
import com.digiwin.app.actuate.DWModuleCompositeHealthContributor;
import com.digiwin.app.module.DWModuleClassLoader;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthIndicator;

public class DWModuleHealthIndicatorContainerBeanPostProcessor
implements BeanPostProcessor {
    private static Log log = LogFactory.getLog(DWModuleHealthIndicatorContainerBeanPostProcessor.class);
    private List<DWAbstractModuleBeanHealthIndicatorProcessor> processors;
    private HealthContributorRegistry registry;

    public DWModuleHealthIndicatorContainerBeanPostProcessor(HealthContributorRegistry registry, List<DWAbstractModuleBeanHealthIndicatorProcessor> processors) throws Exception {
        this.processors = registry == null ? Collections.emptyList() : processors;
        this.registry = registry;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        DWAbstractModuleBeanHealthIndicatorProcessor targetProcessor = null;
        for (int i = 0; i < this.processors.size(); ++i) {
            DWAbstractModuleBeanHealthIndicatorProcessor processor = this.processors.get(i);
            if (!processor.accept(bean)) continue;
            targetProcessor = processor;
            break;
        }
        if (targetProcessor != null) {
            Object subIndicator = targetProcessor.createHealthIndicator(bean);
            String moduleName = DWModuleClassLoader.getCurrentModuleName();
            String indicatorName = moduleName == null ? beanName : "[" + moduleName + "]." + beanName;
            this.addSubHealthIndicator(targetProcessor.getIndicatorName(), indicatorName, (HealthIndicator)subIndicator, targetProcessor.getTargetBeanType());
        }
        return bean;
    }

    private void addSubHealthIndicator(String groupIndicatorName, String subIndicatorName, HealthIndicator subIndicator, Class<?> targetClass) {
        String moduleContributorName = String.format("%s(DAP-Module)", groupIndicatorName);
        Object healthContributor = (HealthContributor)this.registry.getContributor(moduleContributorName);
        boolean isDAPContributor = healthContributor instanceof DWModuleCompositeHealthContributor;
        if (healthContributor == null) {
            healthContributor = new DWModuleCompositeHealthContributor();
            this.registry.registerContributor(moduleContributorName, healthContributor);
        } else if (!isDAPContributor) {
            log.error((Object)String.format("groupIndicatorName(%s) healthContributor is not DWModuleCompositeHealthContributor type, can not add module indicator(%s)", groupIndicatorName, subIndicatorName));
            return;
        }
        ((DWModuleCompositeHealthContributor)healthContributor).add(subIndicatorName, (HealthContributor)subIndicator);
    }
}

