/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.digiwin.app.autoconfigure.metrics.DWAbstractModuleBeanMetricsProcessor;
import com.digiwin.app.metadata.redis.CompositeRedisPoolMetadataProvider;
import com.digiwin.app.metadata.redis.RedisPoolMetadata;
import com.digiwin.app.metadata.redis.RedisPoolMetadataProvider;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.util.CollectionUtils;

public class DWRedisMetrics
extends DWAbstractModuleBeanMetricsProcessor<RedisConnectionFactory> {
    private static Map<Object, String> beanMapTag = new HashMap<Object, String>();
    MeterRegistry registry;
    private RedisPoolMetadataProvider provider;

    public DWRedisMetrics(Map<String, RedisConnectionFactory> connectionFactoryMap, Collection<? extends RedisPoolMetadataProvider> provider, MeterRegistry registry) {
        this.registry = registry;
        this.provider = new CompositeRedisPoolMetadataProvider(new ArrayList<RedisPoolMetadataProvider>(provider));
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            for (Map.Entry<Object, String> entry : beanMapTag.entrySet()) {
                String tagValue = entry.getValue();
                RedisConnectionFactory realBean = (RedisConnectionFactory)this.getRealBean(entry.getKey());
                RedisPoolMetadata redisPoolMetadata = this.provider.getDataSourcePoolMetadata(realBean);
                if (!Objects.nonNull(redisPoolMetadata)) continue;
                Gauge.builder((String)"dwredis.config.max", (Object)"dwredis.config.max", s -> redisPoolMetadata.getMax().intValue()).tag("name", tagValue).register(this.registry);
                Gauge.builder((String)"dwredis.config.min", (Object)"dwredis.config.max", s -> redisPoolMetadata.getMin().intValue()).tag("name", tagValue).register(this.registry);
                Gauge.builder((String)"dwredis.config.current", (Object)"dwredis.config.max", s -> redisPoolMetadata.getcurrent().intValue()).tag("name", tagValue).register(this.registry);
            }
        }, 0L, 60L, TimeUnit.SECONDS);
        if (CollectionUtils.isEmpty(connectionFactoryMap)) {
            return;
        }
        connectionFactoryMap.forEach((beanName, bean) -> {
            RedisConnectionFactory realBean = (RedisConnectionFactory)this.getRealBean(bean);
            if (!beanMapTag.containsKey(realBean)) {
                beanMapTag.put(realBean, (String)beanName);
            }
            this.registry((RedisConnectionFactory)bean);
        });
    }

    @Override
    public void registryMerer(String moudleName, String beanName, RedisConnectionFactory bean) {
        this.registry(bean);
    }

    @Override
    public Map<Object, String> getBeanMapTagMap() {
        return beanMapTag;
    }

    public void registry(RedisConnectionFactory bean) {
        String tagValue = beanMapTag.get(this.getRealBean(bean));
        RedisPoolMetadata redisPoolMetadata = this.provider.getDataSourcePoolMetadata(bean);
        if (Objects.nonNull(redisPoolMetadata)) {
            Gauge.builder((String)"dwredis.config.max", (Object)"dwredis.config.max", s -> redisPoolMetadata.getMax().intValue()).tag("name", tagValue).register(this.registry);
            Gauge.builder((String)"dwredis.config.min", (Object)"dwredis.config.max", s -> redisPoolMetadata.getMin().intValue()).tag("name", tagValue).register(this.registry);
            Gauge.builder((String)"dwredis.config.current", (Object)"dwredis.config.max", s -> redisPoolMetadata.getcurrent().intValue()).tag("name", tagValue).register(this.registry);
        }
    }
}

