/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.digiwin.app.autoconfigure.metrics.DWAbstractModuleBeanMetricsProcessor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public class RedisTemplateMetricsInterceptor
extends DWAbstractModuleBeanMetricsProcessor<RedisConnectionFactory>
implements MethodInterceptor {
    private final String METRICS_NAME = "dwredis.execute";
    @Lazy
    @Autowired
    MeterRegistry registry;
    @Lazy
    @Autowired(required=false)
    Map<String, RedisConnectionFactory> beanMap;
    private static Map<Object, String> beanMapTag = new HashMap<Object, String>();

    @PostConstruct
    public void initTag() {
        if (!CollectionUtils.isEmpty(this.beanMap)) {
            this.beanMap.forEach((beanName, bean) -> {
                Object realBean = this.getRealBean(bean);
                if (!beanMapTag.containsKey(realBean)) {
                    beanMapTag.put(realBean, (String)beanName);
                }
            });
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Object result = null;
        try {
            result = methodInvocation.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            stopWatch.stop();
            Object target = new DirectFieldAccessor((Object)methodInvocation).getPropertyValue("target");
            RedisConnectionFactory targetConnectionFactory = ((RedisTemplate)target).getConnectionFactory();
            RedisConnectionFactory realConnectionFactory = (RedisConnectionFactory)this.getRealBean(targetConnectionFactory);
            String tagValue = beanMapTag.get(realConnectionFactory);
            Timer.builder((String)"dwredis.execute").tag("name", tagValue).register(this.registry).record(stopWatch.getTotalTimeMillis(), TimeUnit.MILLISECONDS);
        }
        return result;
    }

    @Override
    public void registryMerer(String paramString1, String paramString2, RedisConnectionFactory bean) {
        String tagValue = beanMapTag.get(this.getRealBean(bean));
        Timer.builder((String)"dwredis.execute").tag("name", tagValue).register(this.registry);
    }

    @Override
    public Map<Object, String> getBeanMapTagMap() {
        return beanMapTag;
    }
}

