/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dump;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.core.env.Environment;

@Endpoint(id="dw-dumpendpoint")
public class DWDumpEndpoint {
    private static Log log = LogFactory.getLog(DWDumpEndpoint.class);
    private static Lock lock = new ReentrantLock();
    private HotSpotDiagnosticMXBean platformMXBean;
    private String outDir;

    public DWDumpEndpoint(Environment environment) {
        this.outDir = environment.getProperty("dwdumpOutDir");
        this.platformMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadOperation
    public String dump() {
        block7: {
            boolean lockfalg = false;
            try {
                if (lock.tryLock()) {
                    lockfalg = true;
                    this.platformMXBean.dumpHeap(this.outDir + File.separator + System.currentTimeMillis() + ".hprof", true);
                    break block7;
                }
                String string = "dumping";
                return string;
            }
            catch (IOException e) {
                log.error((Object)"dump heap error ", (Throwable)e);
                String string = "fail";
                return string;
            }
            finally {
                if (lockfalg) {
                    lock.unlock();
                }
            }
        }
        return "success";
    }
}

