/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import com.digiwin.app.commons.eai.alarm.EAICallbackDelayed;
import com.digiwin.app.commons.eai.alarm.EaiAlarmApplicationEvent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationListener;

public class EaiCallBackTimeOutMetrics
implements ApplicationListener<EaiAlarmApplicationEvent> {
    private final MeterRegistry registry;
    private final String METRICS_EAI_TIMEOUT = "eai.timeout";
    private final String TAG_TARGET_APP = "targetApp";
    private final String TAG_REQUEST_APP = "requestApp";
    private final String TEANANT_ID = "tenantId";
    private final String API = "api";
    private final String REQ_ID = "reqId";
    private final Cache<String, EAICallbackDelayed> ALARM_APPLICATION_EVENT_CACHE;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    public EaiCallBackTimeOutMetrics(MeterRegistry registry, Integer inital, Integer max, long maxMil) {
        this.registry = registry;
        this.ALARM_APPLICATION_EVENT_CACHE = CacheBuilder.newBuilder().initialCapacity(inital.intValue()).removalListener(notification -> {
            String key = (String)notification.getKey();
            registry.forEachMeter(meter -> {
                String reqId = meter.getId().getTag("reqId");
                if (key.equals(reqId)) {
                    registry.remove(meter);
                }
            });
        }).expireAfterWrite(maxMil, TimeUnit.MILLISECONDS).maximumSize((long)max.intValue()).build();
        this.executor.scheduleAtFixedRate(() -> this.ALARM_APPLICATION_EVENT_CACHE.cleanUp(), 2L, 2L, TimeUnit.MINUTES);
    }

    public void onApplicationEvent(EaiAlarmApplicationEvent event) {
        EAICallbackDelayed delayed = (EAICallbackDelayed)event.getSource();
        this.ALARM_APPLICATION_EVENT_CACHE.put((Object)delayed.getReqId(), (Object)delayed);
        Gauge.builder((String)"eai.timeout", this.ALARM_APPLICATION_EVENT_CACHE, s -> this.ALARM_APPLICATION_EVENT_CACHE.size()).tags(new String[]{"reqId", delayed.getReqId(), "requestApp", delayed.getRequestApp(), "targetApp", delayed.getTargetApp(), "api", delayed.getApi(), "tenantId", delayed.getTenantId()}).register(this.registry);
    }
}

