/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.redis;

import com.digiwin.app.metadata.redis.AbstractRedisPoolMetadata;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisConnectionFactoryPoolMetadata
extends AbstractRedisPoolMetadata<JedisConnectionFactory> {
    public JedisConnectionFactoryPoolMetadata(JedisConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
    }

    @Override
    public Integer getcurrent() {
        GenericObjectPool internalPool = this.getInternalPool();
        if (Objects.nonNull(internalPool)) {
            return internalPool.listAllObjects().size();
        }
        return 0;
    }

    @Override
    public Integer getMax() {
        return ((JedisConnectionFactory)this.getRedisConnectionFactory()).getPoolConfig().getMaxTotal();
    }

    @Override
    public Integer getMin() {
        return ((JedisConnectionFactory)this.getRedisConnectionFactory()).getPoolConfig().getMinIdle();
    }

    public GenericObjectPool getInternalPool() {
        JedisConnectionFactory jedisConnectionFactory = (JedisConnectionFactory)this.getRedisConnectionFactory();
        Object pool = new DirectFieldAccessor((Object)jedisConnectionFactory).getPropertyValue("pool");
        return (GenericObjectPool)pool;
    }
}

