/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.redis;

import com.digiwin.app.metadata.redis.RedisPoolMetadata;
import com.digiwin.app.metadata.redis.RedisPoolMetadataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class CompositeRedisPoolMetadataProvider
implements RedisPoolMetadataProvider {
    private List<RedisPoolMetadataProvider> providerList;

    public CompositeRedisPoolMetadataProvider(List<? extends RedisPoolMetadataProvider> providers) {
        this.providerList = Objects.nonNull(providers) ? new ArrayList<RedisPoolMetadataProvider>(providers) : Collections.emptyList();
    }

    @Override
    public RedisPoolMetadata getDataSourcePoolMetadata(RedisConnectionFactory connectionFactory) {
        for (RedisPoolMetadataProvider provider : this.providerList) {
            RedisPoolMetadata redisPoolMetadata = provider.getDataSourcePoolMetadata(connectionFactory);
            if (!Objects.nonNull(redisPoolMetadata)) continue;
            return redisPoolMetadata;
        }
        return null;
    }
}

