/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

public class HttpClientMetricsInterceptor5
implements MethodInterceptor {
    @Autowired
    @Lazy
    MeterRegistry registry;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Throwable throwable = null;
        Object result = null;
        try {
            result = methodInvocation.proceed();
        }
        catch (Throwable e) {
            try {
                throwable = e;
                throw e;
            }
            catch (Throwable throwable2) {
                stopWatch.stop();
                Tag exceptionTag = Tag.of((String)"exception", (String)(throwable == null ? "None" : throwable.getClass().getSimpleName()));
                Tag methodtag = Tag.of((String)"method", (String)"UNKNOWN");
                Tag statusTag = Tag.of((String)"status", (String)"UNKNOWN");
                Tag uritag = Tag.of((String)"uri", (String)"UNKNOWN");
                if (methodInvocation.getArguments().length > 0 && HttpUriRequest.class.isAssignableFrom(this.getRealObject(methodInvocation.getArguments()[0]).getClass())) {
                    HttpUriRequest request = (HttpUriRequest)this.getRealObject(methodInvocation.getArguments()[0]);
                    uritag = Tag.of((String)"uri", (String)HttpClientMetricsInterceptor5.getPathInfo(request));
                    methodtag = Tag.of((String)"method", (String)request.getMethod());
                    if (Objects.nonNull(result) && HttpResponse.class.isAssignableFrom(result.getClass()) && Objects.nonNull(((HttpResponse)result).getCode())) {
                        statusTag = Tag.of((String)"status", (String)String.valueOf(((HttpResponse)result).getCode()));
                    }
                }
                Timer.builder((String)"dwhttp.request.execute").tags(new String[]{exceptionTag.getKey(), exceptionTag.getValue(), methodtag.getKey(), methodtag.getValue(), statusTag.getKey(), statusTag.getValue(), uritag.getKey(), uritag.getValue()}).register(this.registry).record(stopWatch.getTotalTimeMillis(), TimeUnit.MILLISECONDS);
                throw throwable2;
            }
        }
        stopWatch.stop();
        Tag exceptionTag = Tag.of((String)"exception", (String)(throwable == null ? "None" : throwable.getClass().getSimpleName()));
        Tag methodtag = Tag.of((String)"method", (String)"UNKNOWN");
        Tag statusTag = Tag.of((String)"status", (String)"UNKNOWN");
        Tag uritag = Tag.of((String)"uri", (String)"UNKNOWN");
        if (methodInvocation.getArguments().length > 0 && HttpUriRequest.class.isAssignableFrom(this.getRealObject(methodInvocation.getArguments()[0]).getClass())) {
            HttpUriRequest request = (HttpUriRequest)this.getRealObject(methodInvocation.getArguments()[0]);
            uritag = Tag.of((String)"uri", (String)HttpClientMetricsInterceptor5.getPathInfo(request));
            methodtag = Tag.of((String)"method", (String)request.getMethod());
            if (Objects.nonNull(result) && HttpResponse.class.isAssignableFrom(result.getClass()) && Objects.nonNull(((HttpResponse)result).getCode())) {
                statusTag = Tag.of((String)"status", (String)String.valueOf(((HttpResponse)result).getCode()));
            }
        }
        Timer.builder((String)"dwhttp.request.execute").tags(new String[]{exceptionTag.getKey(), exceptionTag.getValue(), methodtag.getKey(), methodtag.getValue(), statusTag.getKey(), statusTag.getValue(), uritag.getKey(), uritag.getValue()}).register(this.registry).record(stopWatch.getTotalTimeMillis(), TimeUnit.MILLISECONDS);
        return result;
    }

    public Object getRealObject(Object obj) {
        return AopUtils.isAopProxy((Object)obj) ? AopProxyUtils.getSingletonTarget((Object)obj) : obj;
    }

    private static String getPathInfo(HttpUriRequest request) throws URISyntaxException {
        String pathInfo = request.getUri().getPath();
        String uri = StringUtils.hasText((String)pathInfo) ? pathInfo : "/";
        String host = request.getUri().getHost();
        return host + uri.replaceAll("//+", "/").replaceAll("/$", "");
    }
}

