/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.module.event;

import com.digiwin.app.autoconfigure.condition.DWModularModeCondition;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.event.DWAbstractEventContext;
import com.digiwin.gateway.event.DWEvent;
import com.digiwin.gateway.event.DWEventContext;
import com.digiwin.gateway.event.DWEventListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={DWModularModeCondition.class})
public class DWModularEventAutoConfiguration {
    @Bean
    public DWEventContext dwEventContext() {
        return new DWAbstractEventContext(){

            protected <E extends DWEvent> List<DWEventListener<E>> getEventListeners(E event) {
                List moduleNameList = DWModuleSpringUtils.getModuleNameList();
                ArrayList<DWEventListener<E>> allList = new ArrayList<DWEventListener<E>>();
                allList.addAll(this.getEventListeners(SpringContextUtils.getContext(), event));
                for (String moduleName : moduleNameList) {
                    try {
                        ApplicationContext moduleApplicationContext = DWModuleSpringUtils.getModuleSpringContext((String)moduleName);
                        allList.addAll(this.getEventListeners(moduleApplicationContext, event));
                    }
                    catch (Exception e) {
                        Log log = LogFactory.getLog(DWModularEventAutoConfiguration.class);
                        log.error((Object)String.format("DWModularEventAutoConfiguration.DWAbstractEventContext getModuleSpringContext(module name=%s) failed!", moduleName), (Throwable)e);
                    }
                }
                return allList;
            }
        };
    }
}

