/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock.rap;

import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.container.local.mock.DWMockHeader;
import com.digiwin.app.container.local.mock.DWMockInfoProvider;
import com.digiwin.app.container.local.mock.DWMockService;
import com.google.gson.Gson;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public abstract class DWRapMockInfoProvider
implements DWMockInfoProvider {
    private static Log log = LogFactory.getLog(DWRapMockInfoProvider.class);
    private static final String PROPERTIES_NAME = "RAP-setting.properties";
    private String rapServerIpPort = null;
    protected Gson gson = new Gson();
    private String rapProjectId = "4";
    private String rapRestfulServicePath = "api/queryRAPModel.do?projectId=";
    private String rapMockDataServicePath = "?";
    protected Method mockServiceExecuteMethod = null;

    protected DWRapMockInfoProvider() {
        this.initialize();
    }

    public String getRapServiceIpPort() {
        return this.rapServerIpPort;
    }

    public String getRapProjectId() {
        return this.rapProjectId;
    }

    private void initialize() {
        Properties rapProperties = DWPropertiesUtils.getPlatformProperties((String)PROPERTIES_NAME);
        this.rapServerIpPort = rapProperties.getProperty("serverIpPort");
        this.rapProjectId = rapProperties.getProperty("projectId");
        try {
            this.mockServiceExecuteMethod = DWMockService.class.getMethod("execute", Map.class);
        }
        catch (Exception e) {
            new IllegalArgumentException("get DWMockService.execute method failed!", e);
        }
        StringBuilder mockDataUrl = new StringBuilder();
        String dataType = "MOCKJS";
        mockDataUrl.append("http://").append(this.rapServerIpPort).append("/").append(dataType).append("/").append(this.rapProjectId);
        this.rapMockDataServicePath = mockDataUrl.toString();
        log.info((Object)("RAP MOCK DATA SERVICE URL =" + this.rapMockDataServicePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final DWMockHeader[] getMockHeaders() {
        try {
            StringBuilder url = new StringBuilder();
            url.append("http://").append(this.rapServerIpPort).append("/").append(this.rapRestfulServicePath).append(this.rapProjectId);
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                HttpPost request = new HttpPost(url.toString());
                request.addHeader("content-type", "application/json");
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = result.getEntity();
                String json = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                List<Map<String, Object>> rapModuleList = this.getRapModuleMapList(json);
                if (rapModuleList == null) {
                    DWMockHeader[] dWMockHeaderArray2 = new DWMockHeader[]{};
                    return dWMockHeaderArray2;
                }
                DWMockHeader[] dWMockHeaderArray = this.getMockHeadersCore(rapModuleList);
                return dWMockHeaderArray;
            }
        }
        catch (Exception e) {
            log.error((Object)"\u53d6\u5f97 RAP \u5c08\u6848\u4fe1\u606f\u5931\u6557", (Throwable)e);
            return null;
        }
    }

    protected List<Map<String, Object>> getRapModuleMapList(String RAPProjectDataJsonString) {
        Gson gson = new Gson();
        Map rawInfoObject = (Map)gson.fromJson(RAPProjectDataJsonString, Map.class);
        Object modelJSON = rawInfoObject.get("modelJSON");
        if (modelJSON == null) {
            return null;
        }
        Map modelJSONMap = (Map)gson.fromJson(modelJSON.toString(), Map.class);
        List rapModuleList = (List)modelJSONMap.get("moduleList");
        return rapModuleList;
    }

    protected abstract DWMockHeader[] getMockHeadersCore(List<Map<String, Object>> var1) throws Exception;

    protected Object getRealTimeMockDataObject(String mockUrl) throws Exception {
        Map realTimeMockDataObject = null;
        String jsonResult = this.getRealTimeMockData(mockUrl);
        Map outputMap = (Map)this.gson.fromJson(jsonResult, Map.class);
        Object isOk = outputMap.get("isOk");
        if (isOk != null && "false".equals(isOk.toString())) {
            Object msg = outputMap.get("msg");
            if (msg != null) {
                log.error((Object)(">>> Get Real Time RAP Mock Data failed! -> " + msg.toString()));
            } else {
                msg = outputMap.get("errMsg");
                if (msg != null) {
                    log.error((Object)(">>> Get Real Time RAP Mock Data failed! -> " + msg.toString()));
                }
            }
        } else {
            if (outputMap.containsKey("result")) {
                return outputMap.get("result");
            }
            realTimeMockDataObject = outputMap;
        }
        return realTimeMockDataObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getRealTimeMockData(String url) throws Exception {
        log.info((Object)(">>> Get Rap Mock Data, url = " + url));
        try {
            String requestUrl = this.rapMockDataServicePath + "/" + url;
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                String json;
                HttpPost request = new HttpPost(requestUrl);
                request.addHeader("content-type", "application/json");
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = result.getEntity();
                String string = json = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            log.error((Object)"\u53d6\u5f97 RAP \u5c08\u6848\u4fe1\u606f\u5931\u6557", (Throwable)e);
            throw e;
        }
    }

    protected Class<?> getParameterType(String type) {
        if (type == null) {
            return Object.class;
        }
        if ("string".equals(type.toLowerCase())) {
            return String.class;
        }
        return Object.class;
    }
}

