/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.modular.spring;

import com.digiwin.app.resource.DWModuleResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class DWModuleMessageResourceBundleUtilsMessageSource
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;
    private String moduleName;

    public DWModuleMessageResourceBundleUtilsMessageSource(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName == null ? DWServiceContext.getContext().getModuleName() : this.moduleName;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message = DWModuleResourceBundleUtils.getStringByModuleWithDefaultMessage(this.getModuleName(), "message", code, defaultMessage, args);
        if (message == null && this.parentMessageSource != null) {
            message = this.parentMessageSource.getMessage(code, args, defaultMessage, locale);
        }
        return message;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, args, null, null);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new NotImplementedException("unknown purpose, operator not support yet!");
    }

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }
}

