/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.modular.spring;

import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.merge.config.DWSourceAppAwareProperties;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.PropertiesPropertySource;

public class DWApplicationConfigUtilsPropertySource
extends PropertiesPropertySource {
    public static final String DAP_APPLICATION_PROPERTY_SOURCE = "dap-application-propertysource";
    protected static final String PLATFORM_CONFIG_PROPERTIES = "platform";
    protected static final String APPLICATION_CONFIG_PROPERTIES = "application";
    private Properties source;

    private DWApplicationConfigUtilsPropertySource(String name, Properties source) {
        super(name, source);
        this.source = source;
    }

    public Properties getProperties() {
        return this.source;
    }

    public static DWApplicationConfigUtilsPropertySource createInstance() {
        return DWApplicationConfigUtilsPropertySource.createInstance(DAP_APPLICATION_PROPERTY_SOURCE);
    }

    public static DWApplicationConfigUtilsPropertySource createInstance(String name) {
        Properties customizationProperties;
        Properties industryProperties;
        Properties applicationProperties;
        DWSourceAppAwareProperties result = new DWSourceAppAwareProperties();
        Properties platformProperties = DWPropertiesUtils.getPlatformProperties((String)PLATFORM_CONFIG_PROPERTIES);
        if (platformProperties != null) {
            result.putAll((Map<?, ?>)platformProperties);
        }
        if ((applicationProperties = DWPropertiesUtils.getApplicationProperties((String)APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)applicationProperties);
        }
        if ((industryProperties = DWPropertiesUtils.getIndustryProperties((String)APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)industryProperties);
        }
        if ((customizationProperties = DWPropertiesUtils.getCustomizationProperties((String)APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)customizationProperties);
        }
        return new DWApplicationConfigUtilsPropertySource(name, (Properties)result);
    }
}

