/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.modular.spring;

import com.digiwin.app.common.DWPropertiesUtils;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.PropertiesPropertySource;

public class DWModuleConfigUtilsPropertySource
extends PropertiesPropertySource {
    public static final String MODULE_CONFIG_PROPERTIES = "module";
    public static final String DAP_MODULE_PROPERTY_SOURCE = "dap-module-propertysource";

    private DWModuleConfigUtilsPropertySource(String name, Properties source) {
        super(name, source);
    }

    public static DWModuleConfigUtilsPropertySource createInstance(String moduleName) {
        return DWModuleConfigUtilsPropertySource.createInstance(moduleName, DAP_MODULE_PROPERTY_SOURCE);
    }

    public static DWModuleConfigUtilsPropertySource createInstance(String moduleName, String propertySourceName) {
        Properties customizationProperties;
        Properties industryProperties;
        Properties result = new Properties();
        Properties applicationProperties = DWPropertiesUtils.getApplicationModuleProperties((String)MODULE_CONFIG_PROPERTIES, (String)moduleName);
        if (applicationProperties != null) {
            result.putAll((Map<?, ?>)applicationProperties);
        }
        if ((industryProperties = DWPropertiesUtils.getIndustryModuleProperties((String)MODULE_CONFIG_PROPERTIES, (String)moduleName)) != null) {
            result.putAll((Map<?, ?>)industryProperties);
        }
        if ((customizationProperties = DWPropertiesUtils.getCustomizationModuleProperties((String)MODULE_CONFIG_PROPERTIES, (String)moduleName)) != null) {
            result.putAll((Map<?, ?>)customizationProperties);
        }
        return new DWModuleConfigUtilsPropertySource(propertySourceName, result);
    }
}

