/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.resource.utils;

import com.digiwin.app.common.DWPathUtils;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;

public class DWModularI18nUtils {
    public static final int LAYER_STANDARD = -1;
    public static final int LAYER_INDUSTRY = 0;
    public static final int LAYER_CUSTOMIZATION = 1;
    private static ResourceBundle.Control rbc = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);

    public static String[] getPlatformI18nFileNames(String baseName) {
        return DWModularI18nUtils.getI18nFileNames(DWPathUtils.getPlatformLangPath(), baseName, null);
    }

    public static String[] getPlatformI18nFileNames(String baseName, Locale locale) {
        return DWModularI18nUtils.getI18nFileNames(DWPathUtils.getPlatformLangPath(), baseName, locale);
    }

    public static String[] getApplicationI18nFileNames(int layerIndex, String baseName) {
        return DWModularI18nUtils.getApplicationI18nFileNames(layerIndex, baseName, null);
    }

    public static String[] getApplicationI18nFileNames(int layerIndex, String baseName, Locale locale) {
        if (layerIndex > 1) {
            layerIndex = 1;
        }
        String path = "";
        if (layerIndex <= -1) {
            path = DWPathUtils.getApplicationLangPath();
        } else if (layerIndex == 0) {
            path = DWPathUtils.getIndustryLangPath();
        } else if (layerIndex == 1) {
            path = DWPathUtils.getCustomizationLangPath();
        }
        return DWModularI18nUtils.getI18nFileNames(path, baseName, locale);
    }

    public static String[] getModuleI18nFileNames(String moduleName, int layerIndex, String baseName) {
        return DWModularI18nUtils.getModuleI18nFileNames(moduleName, layerIndex, baseName, null);
    }

    public static String[] getModuleI18nFileNames(String moduleName, int layerIndex, String baseName, Locale locale) {
        if (layerIndex > 1) {
            layerIndex = 1;
        }
        String path = "";
        if (layerIndex <= -1) {
            path = DWPathUtils.getApplicationModuleLangPath((String)moduleName);
            if (!new File(path).exists()) {
                path = DWPathUtils.getPlatformModuleLangPath((String)moduleName);
            }
        } else if (layerIndex == 0) {
            path = DWPathUtils.getIndustryModuleLangPath((String)moduleName);
        } else if (layerIndex == 1) {
            path = DWPathUtils.getCustomizationModuleLangPath((String)moduleName);
        }
        return DWModularI18nUtils.getI18nFileNames(path, baseName, locale);
    }

    public static String[] getI18nFileNames(String path, String baseName) {
        return DWModularI18nUtils.getI18nFileNames(path, baseName, null);
    }

    public static String[] getI18nFileNames(String path, String baseName, Locale locale) {
        Set<String> candidateLocaleStringList = DWModularI18nUtils.getCandidateLocaleStringList(baseName, locale);
        return (String[])candidateLocaleStringList.stream().map(localeString -> path + File.separator + baseName + (localeString.isEmpty() ? "" : "_") + localeString + ".properties").toArray(String[]::new);
    }

    public static Set<String> getCandidateLocaleStringList(String baseName, Locale locale) {
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        List<Locale> localeList = rbc.getCandidateLocales(baseName, locale);
        Set candidateSet = localeList.stream().filter(l -> l.getScript().length() == 0 && l.getVariant().length() == 0).map(Locale::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        return candidateSet;
    }
}

