/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.local;

import com.digiwin.app.adapter.ResourceBundleAdapter;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.reader.BaseReader;
import com.digiwin.app.common.config.reader.resource.LocaleReader;
import com.digiwin.app.common.config.reader.resourcebundle.ResourceBundleReader;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalReader
implements BaseReader {
    private static final String TAG = "[LocalReader] ";
    private static Log _log = LogFactory.getLog(LocalReader.class);
    private static Map<String, Properties> configFiles = new HashMap<String, Properties>();
    private ResourceBundleReader i18nReader;

    public LocalReader(ResourceBundleReader resourceBundleReader) {
        Objects.requireNonNull(resourceBundleReader);
        this.i18nReader = resourceBundleReader;
    }

    public String getLog4j2Xml() {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + "log4j2.xml";
        return this.loadFileContent(path);
    }

    public String getPlatformModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String path = DWPathUtils.getPlatformModuleConfPath((String)module) + File.separator + xmlNameWithoutExtension + ".xml";
        return this.loadFileContent(path);
    }

    public String getModuleSpringXml(String module, String xmlNameWithoutExtension) {
        String path = DWPathUtils.getApplicationModuleConfPath((String)module) + File.separator + xmlNameWithoutExtension + ".xml";
        return this.loadFileContent(path);
    }

    public String getApplicationSpringXml(String xmlNameWithoutExtension) {
        String path = DWPathUtils.getApplicationConfPath() + File.separator + xmlNameWithoutExtension + ".xml";
        return this.loadFileContent(path);
    }

    public String getPlatformSpringXml(String xmlNameWithoutExtension) {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + xmlNameWithoutExtension + ".xml";
        return this.loadFileContent(path);
    }

    public String getModuleResource(String module, String nameWithoutExtension, Extension extension) {
        String path = DWPathUtils.getApplicationModuleConfPath((String)module) + File.separator + nameWithoutExtension + "." + extension.getValue();
        String resourceString = this.loadFileContent(path);
        return resourceString;
    }

    public String getApplicationResource(String nameWithoutExtension, Extension extension) {
        String path = DWPathUtils.getApplicationConfPath() + File.separator + nameWithoutExtension + "." + extension.getValue();
        return this.loadFileContent(path);
    }

    public String getPlatformResource(String nameWithoutExtension, Extension extension) {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + nameWithoutExtension + "." + extension.getValue();
        return this.loadFileContent(path);
    }

    public Properties getProperties(String path, String propertiesNameWithoutExtension) {
        Properties properties = null;
        String fileFullName = path + File.separator + propertiesNameWithoutExtension + ".properties";
        if (configFiles.containsKey(fileFullName)) {
            properties = configFiles.get(fileFullName);
            return properties;
        }
        File propertiesFile = new File(fileFullName);
        if (propertiesFile.exists()) {
            URL url;
            try {
                url = propertiesFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                _log.error((Object)("[LocalReader] LocalReader getProperties failed! FileName=" + fileFullName + ", MalformedURLException: message=" + malformedURLException.getMessage()));
                return null;
            }
            if (url != null) {
                try (InputStream propertyInputStream = url.openStream();){
                    properties = new Properties();
                    properties.load(propertyInputStream);
                    configFiles.put(fileFullName, properties);
                }
                catch (IOException ioException) {
                    _log.error((Object)("[LocalReader] LocalReader getProperties failed! FileName=" + fileFullName + ", IOException: message=" + ioException.getMessage()));
                    return null;
                }
            }
        }
        return properties;
    }

    public Properties getApplicationI18nProperties(String baseName, Locale locale) {
        return this.i18nReader.getApplicationI18nProperties(baseName, locale);
    }

    public Properties getModuleI18nProperties(String groupName, String baseName, Locale locale) {
        return this.i18nReader.getModuleI18nProperties(groupName, baseName, locale);
    }

    public String getPlatformString(String baseName, String key, Object ... patternArguments) {
        return this.i18nReader.getPlatformString(baseName, key, patternArguments);
    }

    public String getApplicationString(String baseName, String key, Object ... patternArguments) {
        return this.i18nReader.getApplicationString(baseName, key, patternArguments);
    }

    public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
        return this.i18nReader.getModuleString(moduleName, baseName, key, patternArguments);
    }

    public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        return this.i18nReader.getString(cl, baseName, locale, key, patternArguments);
    }

    private String loadFileContent(String path) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!new File(path).exists()) {
            return null;
        }
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> stringBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            _log.error((Object)("[LocalReader] LocalReader loadFileContent failed! FileName=" + path + ", IOException: message=" + e.getMessage()));
            return null;
        }
        String content = stringBuilder.toString();
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        return content;
    }

    public static class DefaultResourceBundleReaderHelper
    implements ResourceBundleReader {
        public String getPlatformString(String baseName, String key, Object ... patternArguments) {
            ClassLoader platformClassLoader = DWApplicationClassLoader.getInstance().getDWPlatformClassLoader();
            String result = this.getString(platformClassLoader, baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
            return result;
        }

        public String getApplicationString(String baseName, String key, Object ... patternArguments) {
            DWApplicationClassLoader applicationClassLoader = DWApplicationClassLoader.getInstance();
            return this.getString((ClassLoader)applicationClassLoader, baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
        }

        public String getModuleString(String moduleName, String baseName, String key, Object ... patternArguments) {
            DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
            return this.getString((ClassLoader)moduleClassLoader, baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
        }

        public String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
            ResourceBundle rb = null;
            String result = null;
            try {
                rb = ResourceBundle.getBundle(baseName, locale, cl);
                if (rb != null) {
                    result = rb.getString(key);
                }
            }
            catch (MissingResourceException exception) {
                _log.debug((Object)(LocalReader.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                ResourceBundleAdapter resourceBundleAdapter = null;
                try {
                    resourceBundleAdapter = (ResourceBundleAdapter)SpringContextUtils.getBean((String)"resourceBundleAdapter");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (resourceBundleAdapter != null) {
                    result = resourceBundleAdapter.getMessage(key, patternArguments, locale);
                }
            }
            if (result == null) {
                return null;
            }
            if (patternArguments != null && patternArguments.length > 0) {
                result = String.format(result, patternArguments);
            }
            return result;
        }
    }
}

