/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring.scanner;

import com.digiwin.app.common.DWResourceUtils;
import com.digiwin.app.module.DWModuleConfigUtils;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.DWModuleResourceUtils;
import com.digiwin.app.module.spring.scanner.SpringConfigScanner;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWModuleSpringConfigScanner
extends DWModuleScanHelper<Map<String, String[]>>
implements SpringConfigScanner {
    private static final String SPRING_CONFIG_FILE_NAME = "spring-module.xml";

    public DWModuleSpringConfigScanner(List<String> platformModulePaths, List<String> applicationModulePaths) {
        super(platformModulePaths, applicationModulePaths, "xml");
    }

    public DWModuleSpringConfigScanner(Map<String, String> pathMap) {
        super(pathMap, "xml");
    }

    @Override
    protected Map<String, String[]> createScanContext() {
        return new HashMap<String, String[]>();
    }

    @Override
    public void innerScan(Map<String, String[]> scanContext, List<String> paths, boolean isPlatformModule, String targetModuleName) {
        for (String path : paths) {
            File modulePath = new File(path);
            List<File> modulePathDirs = DWModuleSpringConfigScanner.getModuleFiles(modulePath, targetModuleName);
            for (File moduleFile : modulePathDirs) {
                String moduleName = moduleFile.getName();
                ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
                DWModuleFileInfo dwModuleFileInfo = new DWModuleFileInfo(null, null);
                dwModuleFileInfo.setPlatformModule(isPlatformModule);
                fileInfoList.add(dwModuleFileInfo);
                this.onModuleScan(moduleName, (List<DWModuleFileInfo>)fileInfoList, scanContext);
            }
        }
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, Map<String, String[]> scanContext) {
        String[] configs = null;
        ArrayList<String> configsTemp = new ArrayList<String>();
        String springConfigFileNamesSetting = DWModuleConfigUtils.getProperty((String)moduleName, (String)"springConfigFileNames");
        String[] targetConfigs = springConfigFileNamesSetting != null && springConfigFileNamesSetting.trim().length() > 0 ? springConfigFileNamesSetting.split(",") : new String[]{SPRING_CONFIG_FILE_NAME};
        for (String springConfigFileName : targetConfigs) {
            boolean isPlatformModule = fileInfoList.get(0).isPlatformModule();
            File targetFile = null;
            targetFile = isPlatformModule ? DWResourceUtils.getPlatformModuleResource((String)springConfigFileName, (String)moduleName) : DWModuleResourceUtils.getResource((String)springConfigFileName, (String)moduleName);
            if (targetFile == null || !targetFile.exists()) continue;
            configsTemp.add("classpath:" + springConfigFileName);
        }
        configs = configsTemp.toArray(new String[configsTemp.size()]);
        scanContext.put(moduleName, configs);
    }

    @Override
    public Map<String, String[]> doScan() {
        return (Map)this.scan();
    }

    @Override
    public Map<String, String[]> doScan(String moduleName) {
        return (Map)this.scan(moduleName);
    }
}

