/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWResourceUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWModuleClassScanHelper<T>
extends DWModuleScanHelper<T> {
    protected static Log _log = LogFactory.getLog(DWModuleClassScanHelper.class);

    public DWModuleClassScanHelper() {
        super("jar");
    }

    @Deprecated
    public DWModuleClassScanHelper(Map<String, String> folderName) {
        super(folderName, "jar");
    }

    public DWModuleClassScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths) {
        super(platformModulePaths, applicationModulePaths, "jar");
    }

    protected abstract void onClassScan(String var1, DWModuleClassLoader var2, String var3, Class<?> var4, T var5);

    @Deprecated
    protected DWModuleClassLoader getClassLoader(String moduleName, File[] jarFiles) {
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
        if (classLoader == null) {
            ClassLoader parent = this.getClass().getClassLoader();
            classLoader = new DWModuleClassLoader(parent);
            DWModuleClassLoader.addModuleClassLoader((String)moduleName, (DWModuleClassLoader)classLoader);
        }
        for (File f : jarFiles) {
            try {
                URL url = f.toURI().toURL();
                classLoader.addServiceJarURL(url);
            }
            catch (Exception e) {
                _log.error((Object)("module=" + moduleName + ", file=" + f.getName() + " can't add to class loader!"), (Throwable)e);
            }
        }
        return classLoader;
    }

    protected DWModuleClassLoader getClassLoader(String moduleName, DWModuleFileInfo fileInfo) {
        String directoryName = fileInfo.getDirectoryLayer();
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByExactName((String)directoryName);
        if (moduleClassLoader == null) {
            moduleClassLoader = fileInfo.isPlatformModule() ? this.getPlatformModuleClassLoader(moduleName) : this.getApplicationModuleClassLoader(moduleName);
            DWModuleClassLoader.addModuleClassLoader((String)moduleName, (DWModuleClassLoader)moduleClassLoader, (DWModuleFileInfo)fileInfo);
        }
        return moduleClassLoader;
    }

    private DWModuleClassLoader getPlatformModuleClassLoader(String moduleName) {
        ArrayList<File> addToClassLoaderFiles = new ArrayList<File>();
        String platformModulePath = DWPathUtils.getPlatformModulePath((String)moduleName);
        File platformModuleFile = DWResourceUtils.getResource((String)platformModulePath);
        List<File> moduleServiceLibs = this.getLibFiles(platformModuleFile);
        addToClassLoaderFiles.addAll(moduleServiceLibs);
        addToClassLoaderFiles.add(platformModuleFile);
        String platformModuleConfPath = DWPathUtils.getPlatformModuleConfPath((String)moduleName);
        File platformModuleConfFile = DWResourceUtils.getResource((String)platformModuleConfPath);
        addToClassLoaderFiles.add(platformModuleConfFile);
        String platformModuleLangPath = DWPathUtils.getPlatformModuleLangPath((String)moduleName);
        File platformModuleLangFile = DWResourceUtils.getResource((String)platformModuleLangPath);
        addToClassLoaderFiles.add(platformModuleLangFile);
        String platformModuleLibPath = DWPathUtils.getPlatformModuleLibPath((String)moduleName);
        File platformModuleLibFile = DWResourceUtils.getResource((String)platformModuleLibPath);
        List<File> platformModuleLibFiles = this.getLibFiles(platformModuleLibFile);
        addToClassLoaderFiles.addAll(platformModuleLibFiles);
        DWApplicationClassLoader parent = DWApplicationClassLoader.getInstance();
        URL[] addToClassLoaderUrls = this.convertFilesToURLs(moduleName, addToClassLoaderFiles);
        DWModuleClassLoader classLoader = new DWModuleClassLoader(addToClassLoaderUrls, (ClassLoader)parent);
        return classLoader;
    }

    private DWModuleClassLoader getApplicationModuleClassLoader(String moduleName) {
        ArrayList<File> addToClassLoaderFiles = new ArrayList<File>();
        String applicationModulePath = DWPathUtils.getApplicationModulePath((String)moduleName);
        File applicationModuleFile = DWResourceUtils.getResource((String)applicationModulePath);
        String industryModulePath = DWPathUtils.getIndustryModulePath((String)moduleName);
        File industryModuleFile = DWResourceUtils.getResource((String)industryModulePath);
        String customizationModulePath = DWPathUtils.getCustomizationModulePath((String)moduleName);
        File customizationModuleFile = DWResourceUtils.getResource((String)customizationModulePath);
        List<File> customizationModuleServiceLibs = this.getLibFiles(customizationModuleFile);
        addToClassLoaderFiles.addAll(customizationModuleServiceLibs);
        List<File> industryModuleServiceLibs = this.getLibFiles(industryModuleFile);
        addToClassLoaderFiles.addAll(industryModuleServiceLibs);
        List<File> applicationModuleServiceLibs = this.getLibFiles(applicationModuleFile);
        addToClassLoaderFiles.addAll(applicationModuleServiceLibs);
        addToClassLoaderFiles.add(customizationModuleFile);
        addToClassLoaderFiles.add(industryModuleFile);
        addToClassLoaderFiles.add(applicationModuleFile);
        String customizationModuleConfPath = DWPathUtils.getCustomizationModuleConfPath((String)moduleName);
        File customizationModuleConfFile = DWResourceUtils.getResource((String)customizationModuleConfPath);
        addToClassLoaderFiles.add(customizationModuleConfFile);
        String industryModuleConfPath = DWPathUtils.getIndustryModuleConfPath((String)moduleName);
        File industryModuleConfFile = DWResourceUtils.getResource((String)industryModuleConfPath);
        addToClassLoaderFiles.add(industryModuleConfFile);
        String applicationModuleConfPath = DWPathUtils.getApplicationModuleConfPath((String)moduleName);
        File applicationModuleConfFile = DWResourceUtils.getResource((String)applicationModuleConfPath);
        addToClassLoaderFiles.add(applicationModuleConfFile);
        String customizationModuleLangPath = DWPathUtils.getCustomizationModuleLangPath((String)moduleName);
        File customizationModuleLangFile = DWResourceUtils.getResource((String)customizationModuleLangPath);
        addToClassLoaderFiles.add(customizationModuleLangFile);
        String industryModuleLangPath = DWPathUtils.getIndustryModuleLangPath((String)moduleName);
        File industryModuleLangFile = DWResourceUtils.getResource((String)industryModuleLangPath);
        addToClassLoaderFiles.add(industryModuleLangFile);
        String applicationModuleLangPath = DWPathUtils.getApplicationModuleLangPath((String)moduleName);
        File applicationModuleLangFile = DWResourceUtils.getResource((String)applicationModuleLangPath);
        addToClassLoaderFiles.add(applicationModuleLangFile);
        String customizationModuleLibPath = DWPathUtils.getCustomizationModuleLibPath((String)moduleName);
        File customizationModuleLibFile = DWResourceUtils.getResource((String)customizationModuleLibPath);
        List<File> customizationModuleLibFiles = this.getLibFiles(customizationModuleLibFile);
        addToClassLoaderFiles.addAll(customizationModuleLibFiles);
        String industryModuleLibPath = DWPathUtils.getIndustryModuleLibPath((String)moduleName);
        File industryModuleLibFile = DWResourceUtils.getResource((String)industryModuleLibPath);
        List<File> industryModuleLibFiles = this.getLibFiles(industryModuleLibFile);
        addToClassLoaderFiles.addAll(industryModuleLibFiles);
        String applicationModuleLibPath = DWPathUtils.getApplicationModuleLibPath((String)moduleName);
        File applicationModuleLibFile = DWResourceUtils.getResource((String)applicationModuleLibPath);
        List<File> applicationModuleLibFiles = this.getLibFiles(applicationModuleLibFile);
        addToClassLoaderFiles.addAll(applicationModuleLibFiles);
        DWApplicationClassLoader parent = DWApplicationClassLoader.getInstance();
        URL[] addToClassLoaderUrls = this.convertFilesToURLs(moduleName, addToClassLoaderFiles);
        DWModuleClassLoader classLoader = new DWModuleClassLoader(addToClassLoaderUrls, (ClassLoader)parent);
        return classLoader;
    }

    private URL[] convertFilesToURLs(String moduleName, List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                URL url = file.toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                _log.error((Object)("module=" + moduleName + ", file=" + file.getName() + " can't add to class loader!"), (Throwable)e);
            }
        }
        URL[] urlsToArray = new URL[urls.size()];
        urls.toArray(urlsToArray);
        return urlsToArray;
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, T scanContext) {
        for (DWModuleFileInfo fileInfo : fileInfoList) {
            File[] files = fileInfo.getFiles();
            DWModuleClassLoader classLoader = this.getClassLoader(moduleName, fileInfo);
            for (File file : files) {
                try {
                    JarFile jarFile = new JarFile(file);
                    this.onJarScan(moduleName, jarFile, classLoader, scanContext);
                }
                catch (Exception e) {
                    this.onJarScanFiled(moduleName, file, e);
                }
            }
        }
    }

    protected void onJarScan(String moduleName, JarFile jarFile, DWModuleClassLoader classLoader, T scanContext) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
            String className = jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6);
            try {
                Class clazz = classLoader.loadClass(className);
                this.onClassScan(moduleName, classLoader, jarFile.getName(), clazz, scanContext);
            }
            catch (Throwable e) {
                this.onClassScanFailed(moduleName, jarFile, className, e);
            }
        }
        try {
            jarFile.close();
        }
        catch (Exception e) {
            _log.error((Object)("file=" + jarFile.getName() + " can't close properly!"), (Throwable)e);
        }
    }

    protected void onJarScanFiled(String moduleName, File file, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName()).append(" scan failed!");
        _log.error((Object)message.toString(), (Throwable)e);
    }

    protected void onClassScanFailed(String moduleName, JarFile file, String className, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName());
        message.append(" class=").append(className).append(" scan failed!");
        _log.info((Object)message);
        e.printStackTrace();
    }
}

