/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.module.utils.DWDeveloperServiceCSVReader;
import com.digiwin.app.module.utils.DWDeveloperServicePathManager;
import com.digiwin.app.module.utils.DWResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class DWModuleResourceUtils {
    private static Log _log = LogFactory.getLog(DWModuleResourceUtils.class);
    public static final String EXTENDED_DIRECTORY = "Customized";

    public static String getModuleName(Object serviceInstance) {
        Class<?> serviceClass = serviceInstance.getClass();
        return DWModuleResourceUtils.getModuleName(serviceClass);
    }

    public static String getModuleName(Class<?> moduleClass) {
        return DWModuleClassLoader.getModuleName((ClassLoader)moduleClass.getClassLoader());
    }

    public static Properties getProperties(Object serviceInstance, String fileName) {
        Class<?> serviceClass = serviceInstance.getClass();
        return DWModuleResourceUtils.getProperties(serviceClass, fileName);
    }

    public static Properties getProperties(Class<?> moduleClass, String fileName) {
        String moduleName = DWModuleClassLoader.getModuleName((ClassLoader)moduleClass.getClassLoader());
        return DWModuleResourceUtils.getProperties(moduleName, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String moduleName, String fileName) {
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("moduleName is null or empty!");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName is null or empty!");
        }
        Properties properties = new Properties();
        File targetFile = DWModuleResourceUtils.getResource(moduleName, fileName);
        if (targetFile != null) {
            InputStream propertyInputStream = null;
            try {
                URL url = targetFile.toURI().toURL();
                propertyInputStream = url.openStream();
                properties.load(propertyInputStream);
            }
            catch (Exception e) {
                _log.error((Object)("getProperties->" + moduleName + "." + fileName), (Throwable)e);
            }
            finally {
                if (propertyInputStream != null) {
                    try {
                        propertyInputStream.close();
                    }
                    catch (IOException e) {
                        _log.error((Object)("getProperties->" + moduleName + "." + fileName), (Throwable)e);
                    }
                }
            }
        }
        return properties;
    }

    public static File getFile(Object serviceInstance, String fileName) {
        Class<?> serviceClass = serviceInstance.getClass();
        return DWModuleResourceUtils.getFile(serviceClass, fileName);
    }

    public static File getFile(Class<?> moduleClass, String fileName) {
        String moduleName = DWModuleClassLoader.getModuleName((ClassLoader)moduleClass.getClassLoader());
        return DWModuleResourceUtils.getFile(moduleName, fileName);
    }

    public static File getFile(String moduleName, String fileName) {
        return DWModuleResourceUtils.getResource(moduleName, fileName);
    }

    public static File getResource(String moduleName, String resourceName) {
        File targetFile = null;
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
        URL url = classLoader.getResource(resourceName);
        if (url != null) {
            try {
                targetFile = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                _log.error((Object)"url.toURI() failed!", (Throwable)e);
            }
        }
        return targetFile;
    }

    public static File getCurrentModuleResource(String resourceName) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleResourceUtils.getResource(moduleName, resourceName);
    }

    public static Properties getCurrentModuleProperties(String resourceName) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleResourceUtils.getProperties(moduleName, resourceName);
    }

    @Deprecated
    public static File getModuleDirectory(String moduleName) {
        File rootDirectory = new File(DWResourceUtils.getFolderServicePath());
        if (!rootDirectory.exists()) {
            return null;
        }
        File moduleDirectory = null;
        for (File subItem : rootDirectory.listFiles()) {
            if (!subItem.isDirectory() || !StringUtils.equalsIgnoreCase((CharSequence)subItem.getName(), (CharSequence)moduleName)) continue;
            moduleDirectory = subItem;
            break;
        }
        if (moduleDirectory != null) {
            return moduleDirectory;
        }
        if (SpringContextUtils.containsBean("DWDeveloperSpringConfigScanner")) {
            DWDeveloperServiceCSVReader reader = new DWDeveloperServiceCSVReader();
            List<CSVRecord> csvRecords = reader.getCSVRecords();
            for (CSVRecord record : csvRecords) {
                String csvModuleName = record.get("moduleName");
                if (!moduleName.equals(csvModuleName)) continue;
                String implementPath = record.get("implementPath");
                DWDeveloperServicePathManager pathManager = new DWDeveloperServicePathManager(implementPath);
                return new File(pathManager.getProjectPath());
            }
        }
        return moduleDirectory;
    }

    private static File getModuleDirectory(File rootDirectory, String moduleName) {
        File moduleDirectory = null;
        for (File subItem : rootDirectory.listFiles()) {
            if (!subItem.isDirectory() || !StringUtils.equalsIgnoreCase((CharSequence)subItem.getName(), (CharSequence)moduleName)) continue;
            moduleDirectory = subItem;
            break;
        }
        return moduleDirectory;
    }

    public static File getSubDirectory(File root, String directoryName) {
        for (File subItem : root.listFiles()) {
            if (!subItem.isDirectory() || !subItem.getName().equalsIgnoreCase(directoryName) || subItem.listFiles().length == 0) continue;
            root = subItem;
            return DWModuleResourceUtils.getSubDirectory(root, directoryName);
        }
        return root;
    }

    public static File getSubFile(File root, String fileName) {
        for (File subItem : root.listFiles()) {
            if (!subItem.isFile() || !subItem.getName().equalsIgnoreCase(fileName)) continue;
            root = subItem;
            return root;
        }
        return root;
    }
}

