/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleInfoProvider;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.utils.DWProfileScanHelper;
import com.digiwin.app.module.utils.DWServiceScanHelper;
import com.digiwin.app.service.DWAbstractServiceProcessor;
import com.digiwin.app.service.DWServiceDefinitionParser;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWModuleServiceProcessor
extends DWAbstractServiceProcessor {
    private static Log _log = LogFactory.getLog(DWModuleServiceProcessor.class);

    public DWModuleServiceProcessor(List<DWServiceDefinitionParser> parsers) {
        super(parsers);
    }

    public void process() {
        _log.info((Object)"DWModuleDWServiceProcessor start to search DWService...");
        List<String> platformModulePaths = DWModuleSpringUtils.getPlatformModulePaths();
        List<String> applicationModulePaths = DWModuleSpringUtils.getApplicationModulePaths();
        DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper(platformModulePaths, applicationModulePaths);
        Map<String, List<Class<?>>> interfaces = interfaceScanHelper.scan();
        int totalCount = 0;
        for (Map.Entry<String, List<Class<?>>> item : interfaces.entrySet()) {
            this.log(item.getKey(), item.getValue(), totalCount);
            totalCount += item.getValue().size();
        }
        DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper(platformModulePaths, applicationModulePaths);
        Map<String, List<DWServiceInfo>> implementations = implementationScanHelper.scan();
        for (DWServiceDefinitionParser parser : this.parsers) {
            parser.parseInterface(interfaces);
            parser.parseImplementation(implementations);
        }
        DWModuleInfoProvider.setInterfaceInfos(interfaces);
        DWModuleInfoProvider.setImplementations(implementations);
    }

    public void process(String groupName) {
        _log.info((Object)("DWModuleDWServiceProcessor start to search module = " + groupName + " DWService..."));
        DWModuleClassLoader.removeModuleClassLoader((String)groupName);
        DWModuleSpringUtils.refresh(groupName);
        List<String> platformModulePaths = DWModuleSpringUtils.getPlatformModulePaths();
        List<String> applicationModulePaths = DWModuleSpringUtils.getApplicationModulePaths();
        DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper(platformModulePaths, applicationModulePaths);
        Map<String, List<Class<?>>> interfaces = interfaceScanHelper.scan(groupName);
        DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper(platformModulePaths, applicationModulePaths);
        Map<String, List<DWServiceInfo>> implementations = implementationScanHelper.scan(groupName);
        List<Class<?>> groupInterfaceList = interfaces.get(groupName);
        this.log(groupName, groupInterfaceList, null);
        for (DWServiceDefinitionParser parser : this.parsers) {
            parser.parseInterface(groupName, groupInterfaceList);
            parser.parseImplementation(groupName, implementations.get(groupName));
        }
    }

    private void log(String groupName, List<Class<?>> interfaceList, Integer startIndex) {
        StringBuilder message = new StringBuilder();
        int i = startIndex == null ? 0 : startIndex;
        for (Class<?> interfaceClass : interfaceList) {
            message.setLength(0);
            message.append(">>> Found Header ").append(++i).append(".");
            message.append("group=").append(groupName);
            message.append(", service name=").append(interfaceClass.getSimpleName());
            message.append(", type=").append(interfaceClass.getName());
            _log.info((Object)message.toString());
        }
    }
}

