/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.service.DWServiceBuilder;
import org.springframework.context.ApplicationContext;

public class DWSpringServiceBuilder
implements DWServiceBuilder {
    public Object build(Object service) throws Exception {
        if (service == null) {
            return null;
        }
        String moduleName = this.getModuleName(service);
        return this.buildSpringService(service, moduleName);
    }

    public Object build(Object service, String moduleName) throws Exception {
        return this.buildSpringService(service, moduleName);
    }

    private Object buildSpringService(Object service, String moduleName) throws Exception {
        if (service == null) {
            return null;
        }
        ApplicationContext context = DWModuleSpringUtils.getModuleSpringContext(moduleName);
        if (context != null) {
            String beanId = this.getBeanId(service);
            try {
                Object springBean = context.getBean(beanId);
                return springBean;
            }
            catch (Exception exception) {
                service = this.createInstance(service);
                context.getAutowireCapableBeanFactory().autowireBean(service);
                Object springBean = context.getAutowireCapableBeanFactory().applyBeanPostProcessorsAfterInitialization(service, beanId);
                return springBean;
            }
        }
        service = this.createInstance(service);
        return service;
    }

    private Object createInstance(Object service) throws Exception {
        if (service instanceof Class) {
            return ((Class)service).newInstance();
        }
        return service;
    }

    private String getBeanId(Object service) {
        if (service instanceof Class) {
            return ((Class)service).getSimpleName();
        }
        return service.getClass().getSimpleName();
    }

    private String getModuleName(Object service) {
        ClassLoader classLoader = null;
        classLoader = service instanceof Class ? ((Class)service).getClassLoader() : service.getClass().getClassLoader();
        String moduleName = DWModuleClassLoader.getModuleName((ClassLoader)classLoader);
        return moduleName;
    }
}

