/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWResourceUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWModuleClassScanHelper;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class DWModuleScanHelper<T> {
    private List<String> _platformModulePaths;
    private List<String> _applicationModulePaths;
    protected String _extensionName;

    public DWModuleScanHelper(String extensionName) {
        this._extensionName = extensionName;
    }

    public DWModuleScanHelper(List<String> platformModulePaths, List<String> applicationModulePaths, String extensionName) {
        this._platformModulePaths = platformModulePaths;
        this._applicationModulePaths = applicationModulePaths;
        this._extensionName = extensionName;
    }

    public DWModuleScanHelper() {
    }

    public T scan() {
        T scanContext = this.createScanContext();
        this.innerScan(scanContext, this._platformModulePaths, true, null);
        this.innerScan(scanContext, this._applicationModulePaths, false, null);
        return scanContext;
    }

    public void innerScan(T scanContext, List<String> paths, boolean isPlatformModule, String targetModuleName) {
        for (String path : paths) {
            File modulePath = new File(path);
            List<File> modulePathDirs = DWModuleScanHelper.getModuleFiles(modulePath, targetModuleName);
            for (File moduleFile : modulePathDirs) {
                String moduleName = moduleFile.getName();
                ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
                this.createModuleFileList(fileInfoList, moduleFile, moduleName, isPlatformModule);
                this.onModuleScan(moduleName, fileInfoList, scanContext);
            }
        }
    }

    protected List<File> getLibFiles(File file) {
        ArrayList<File> result = new ArrayList<File>();
        FileFilter extensionFilter = this._extensionName == null ? null : DWModuleScanHelper.getExtensionFilter(this._extensionName);
        File[] filteredFiles = file.listFiles(extensionFilter);
        if (filteredFiles != null) {
            for (File filtersFile : filteredFiles) {
                result.add(filtersFile);
            }
        }
        return result;
    }

    protected List<DWModuleFileInfo> createModuleFileList(List<DWModuleFileInfo> fileInfoList, File file, String directoryLayer, boolean isPlatformModule) {
        FileFilter extensionFilter;
        FileFilter fileFilter = extensionFilter = this._extensionName == null ? null : DWModuleScanHelper.getExtensionFilter(this._extensionName);
        if (fileInfoList == null) {
            fileInfoList = new ArrayList<DWModuleFileInfo>();
        }
        File[] files = file.listFiles(extensionFilter);
        DWModuleFileInfo fileInfo = new DWModuleFileInfo(files, file);
        String parentDirectoryLayer = StringUtils.substringBeforeLast((String)directoryLayer, (String)"\\");
        fileInfo.setDirectoryLayer(directoryLayer);
        fileInfo.setParentDirectoryLayer(parentDirectoryLayer);
        fileInfo.setPlatformModule(isPlatformModule);
        fileInfoList.add(fileInfo);
        return fileInfoList;
    }

    public T scan(String moduleName) {
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("moduleName is null or empty!");
        }
        T scanContext = this.createScanContext();
        this.innerScan(scanContext, this._platformModulePaths, true, moduleName);
        this.innerScan(scanContext, this._applicationModulePaths, false, moduleName);
        return scanContext;
    }

    protected abstract T createScanContext();

    protected abstract void onModuleScan(String var1, List<DWModuleFileInfo> var2, T var3);

    private static FileFilter getExtensionFilter(final String extensionName) {
        if (extensionName == null || extensionName.isEmpty()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith("." + extensionName);
            }
        };
        return filter;
    }

    protected static List<File> getModuleFiles(File targetFile, String moduleName) {
        ArrayList<File> result = new ArrayList<File>();
        File[] targetModuleFiles = targetFile.listFiles();
        if (targetModuleFiles == null) {
            return result;
        }
        for (File targetModuleFile : targetModuleFiles) {
            if (!targetModuleFile.isDirectory()) continue;
            if (moduleName != null) {
                if (!targetModuleFile.getName().equals(moduleName)) continue;
                result.add(targetModuleFile);
                break;
            }
            result.add(targetModuleFile);
        }
        return result;
    }

    protected DWModuleClassLoader getClassLoader(String moduleName, DWModuleFileInfo fileInfo) {
        String directoryName = fileInfo.getDirectoryLayer();
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByExactName((String)directoryName);
        if (moduleClassLoader == null) {
            moduleClassLoader = fileInfo.isPlatformModule() ? this.getPlatformModuleClassLoader(moduleName) : this.getApplicationModuleClassLoader(moduleName);
            DWModuleClassLoader.addModuleClassLoader((String)moduleName, (DWModuleClassLoader)moduleClassLoader, (DWModuleFileInfo)fileInfo);
        }
        return moduleClassLoader;
    }

    protected DWModuleClassLoader getPlatformModuleClassLoader(String moduleName) {
        ArrayList<File> addToClassLoaderFiles = new ArrayList<File>();
        String platformModulePath = DWPathUtils.getPlatformModulePath((String)moduleName);
        File platformModuleFile = DWResourceUtils.getResource((String)platformModulePath);
        List<File> moduleServiceLibs = this.getLibFiles(platformModuleFile);
        addToClassLoaderFiles.addAll(moduleServiceLibs);
        addToClassLoaderFiles.add(platformModuleFile);
        String platformModuleConfPath = DWPathUtils.getPlatformModuleConfPath((String)moduleName);
        File platformModuleConfFile = DWResourceUtils.getResource((String)platformModuleConfPath);
        addToClassLoaderFiles.add(platformModuleConfFile);
        String platformModuleLangPath = DWPathUtils.getPlatformModuleLangPath((String)moduleName);
        File platformModuleLangFile = DWResourceUtils.getResource((String)platformModuleLangPath);
        addToClassLoaderFiles.add(platformModuleLangFile);
        String platformModuleLibPath = DWPathUtils.getPlatformModuleLibPath((String)moduleName);
        File platformModuleLibFile = DWResourceUtils.getResource((String)platformModuleLibPath);
        List<File> platformModuleLibFiles = this.getLibFiles(platformModuleLibFile);
        addToClassLoaderFiles.addAll(platformModuleLibFiles);
        DWApplicationClassLoader parent = DWApplicationClassLoader.getInstance();
        URL[] addToClassLoaderUrls = this.convertFilesToURLs(moduleName, addToClassLoaderFiles);
        DWModuleClassLoader classLoader = new DWModuleClassLoader(addToClassLoaderUrls, (ClassLoader)parent);
        return classLoader;
    }

    protected DWModuleClassLoader getApplicationModuleClassLoader(String moduleName) {
        ArrayList<File> addToClassLoaderFiles = new ArrayList<File>();
        String applicationModulePath = DWPathUtils.getApplicationModulePath((String)moduleName);
        File applicationModuleFile = DWResourceUtils.getResource((String)applicationModulePath);
        String industryModulePath = DWPathUtils.getIndustryModulePath((String)moduleName);
        File industryModuleFile = DWResourceUtils.getResource((String)industryModulePath);
        String customizationModulePath = DWPathUtils.getCustomizationModulePath((String)moduleName);
        File customizationModuleFile = DWResourceUtils.getResource((String)customizationModulePath);
        List<File> customizationModuleServiceLibs = this.getLibFiles(customizationModuleFile);
        addToClassLoaderFiles.addAll(customizationModuleServiceLibs);
        List<File> industryModuleServiceLibs = this.getLibFiles(industryModuleFile);
        addToClassLoaderFiles.addAll(industryModuleServiceLibs);
        List<File> applicationModuleServiceLibs = this.getLibFiles(applicationModuleFile);
        addToClassLoaderFiles.addAll(applicationModuleServiceLibs);
        addToClassLoaderFiles.add(customizationModuleFile);
        addToClassLoaderFiles.add(industryModuleFile);
        addToClassLoaderFiles.add(applicationModuleFile);
        String customizationModuleConfPath = DWPathUtils.getCustomizationModuleConfPath((String)moduleName);
        File customizationModuleConfFile = DWResourceUtils.getResource((String)customizationModuleConfPath);
        addToClassLoaderFiles.add(customizationModuleConfFile);
        String industryModuleConfPath = DWPathUtils.getIndustryModuleConfPath((String)moduleName);
        File industryModuleConfFile = DWResourceUtils.getResource((String)industryModuleConfPath);
        addToClassLoaderFiles.add(industryModuleConfFile);
        String applicationModuleConfPath = DWPathUtils.getApplicationModuleConfPath((String)moduleName);
        File applicationModuleConfFile = DWResourceUtils.getResource((String)applicationModuleConfPath);
        addToClassLoaderFiles.add(applicationModuleConfFile);
        String customizationModuleLangPath = DWPathUtils.getCustomizationModuleLangPath((String)moduleName);
        File customizationModuleLangFile = DWResourceUtils.getResource((String)customizationModuleLangPath);
        addToClassLoaderFiles.add(customizationModuleLangFile);
        String industryModuleLangPath = DWPathUtils.getIndustryModuleLangPath((String)moduleName);
        File industryModuleLangFile = DWResourceUtils.getResource((String)industryModuleLangPath);
        addToClassLoaderFiles.add(industryModuleLangFile);
        String applicationModuleLangPath = DWPathUtils.getApplicationModuleLangPath((String)moduleName);
        File applicationModuleLangFile = DWResourceUtils.getResource((String)applicationModuleLangPath);
        addToClassLoaderFiles.add(applicationModuleLangFile);
        String customizationModuleLibPath = DWPathUtils.getCustomizationModuleLibPath((String)moduleName);
        File customizationModuleLibFile = DWResourceUtils.getResource((String)customizationModuleLibPath);
        List<File> customizationModuleLibFiles = this.getLibFiles(customizationModuleLibFile);
        addToClassLoaderFiles.addAll(customizationModuleLibFiles);
        String industryModuleLibPath = DWPathUtils.getIndustryModuleLibPath((String)moduleName);
        File industryModuleLibFile = DWResourceUtils.getResource((String)industryModuleLibPath);
        List<File> industryModuleLibFiles = this.getLibFiles(industryModuleLibFile);
        addToClassLoaderFiles.addAll(industryModuleLibFiles);
        String applicationModuleLibPath = DWPathUtils.getApplicationModuleLibPath((String)moduleName);
        File applicationModuleLibFile = DWResourceUtils.getResource((String)applicationModuleLibPath);
        List<File> applicationModuleLibFiles = this.getLibFiles(applicationModuleLibFile);
        addToClassLoaderFiles.addAll(applicationModuleLibFiles);
        DWApplicationClassLoader parent = DWApplicationClassLoader.getInstance();
        URL[] addToClassLoaderUrls = this.convertFilesToURLs(moduleName, addToClassLoaderFiles);
        DWModuleClassLoader classLoader = new DWModuleClassLoader(addToClassLoaderUrls, (ClassLoader)parent);
        return classLoader;
    }

    private URL[] convertFilesToURLs(String moduleName, List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                URL url = file.toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                DWModuleClassScanHelper._log.error((Object)("module=" + moduleName + ", file=" + file.getName() + " can't add to class loader!"), (Throwable)e);
            }
        }
        URL[] urlsToArray = new URL[urls.size()];
        urls.toArray(urlsToArray);
        return urlsToArray;
    }
}

