/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWServiceScanHelperUtils {
    static void onClassScan(String moduleName, DWModuleClassLoader classLoader, Class<?> clazz, Map<String, List<DWServiceInfo>> scanContext) {
        DWServiceScanHelperUtils.onClassScan(moduleName, classLoader, null, clazz, scanContext);
    }

    static void onClassScan(String moduleName, DWModuleClassLoader classLoader, String jarName, Class<?> clazz, Map<String, List<DWServiceInfo>> scanContext) {
        Class<?>[] interfaces;
        if (clazz.isInterface()) {
            return;
        }
        for (Class<?> serviceInterface : interfaces = clazz.getInterfaces()) {
            if (!DWServiceScanHelperUtils.isDWServiceImplementation(serviceInterface)) continue;
            DWServiceScanHelperUtils.addServiceInfo(moduleName, serviceInterface, clazz, scanContext);
        }
    }

    private static boolean isDWServiceImplementation(Class<?> interfaceClazz) {
        Class<?>[] interfaces;
        for (Class<?> serviceInterface : interfaces = interfaceClazz.getInterfaces()) {
            if (serviceInterface != DWService.class) continue;
            return true;
        }
        return false;
    }

    private static void addServiceInfo(String moduleName, Class<?> serviceInterface, Class<?> serviceImplement, Map<String, List<DWServiceInfo>> scanContext) {
        List<DWServiceInfo> serviceList = scanContext.get(moduleName);
        if (serviceList == null) {
            serviceList = new ArrayList<DWServiceInfo>();
            scanContext.put(moduleName, serviceList);
        }
        DWServiceInfo oldVerServiceInfo = null;
        for (DWServiceInfo serviceInfo : serviceList) {
            if (!serviceInfo.getInterfaceType().getName().equals(serviceInterface.getName())) continue;
            oldVerServiceInfo = serviceInfo;
            break;
        }
        if (oldVerServiceInfo != null) {
            serviceList.remove(oldVerServiceInfo);
        }
        serviceList.add(new DWServiceInfo(moduleName, serviceInterface, serviceImplement));
    }
}

