/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.mybatis.DWMybatisConstants;
import com.digiwin.app.dao.mybatis.DWMybatisSqlManagementField;
import com.digiwin.app.dao.mybatis.utils.DWMybatisSqlStatementHelper;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DWMybatisTenantLineInnerInterceptor
extends TenantLineInnerInterceptor {
    protected static final Log _LOGGER = LogFactory.getLog(DWMybatisTenantLineInnerInterceptor.class);
    private static final String _LOGTAG = "[" + DWMybatisTenantLineInnerInterceptor.class.getSimpleName() + "]";
    private int sqlLogMaxLength = 200;
    private static String tenantColumnName = DWMybatisConstants.tenantColumnname;
    private static String IAM_TENANTSIDKEY = DWTenantUtils.getIAMTenantSidKey();
    private static String dwMybatisSqlStatementAffix = "%%";
    private static String mybatisBaseTenantTag = "{" + tenantColumnName + "}";
    private static String mybatisBaseTenantNameTag = "{tenantName}";
    private static String mybatisBaseTenantValueTag = "{tenantValue}";
    private static String sqlTenantTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantNameTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantValueTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantNameTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantValueTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");
    private static final HashSet<SqlCommandType> MgmtSqlCommandTypeSet = new HashSet<SqlCommandType>(Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE));
    String regEx = "(?s).%%\\{.*?" + tenantColumnName + "\\}" + dwMybatisSqlStatementAffix;
    String regExCheckTenantTag = "(?s).*?" + tenantColumnName + "\\}" + dwMybatisSqlStatementAffix;
    String basePrefixRegexp = "(?s)%{2}\\{";
    String basePostfixRegexp = "\\}%{2}";
    String regExTagWithAlias = this.basePrefixRegexp + "[/\\w-]+\\." + tenantColumnName + this.basePostfixRegexp;
    String postfixRegex = "." + tenantColumnName + this.basePostfixRegexp;
    private Pattern patternTagWithAlias = Pattern.compile(this.regExTagWithAlias);

    public DWMybatisTenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        super(tenantLineHandler);
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        BoundSql boundSql = sh.getBoundSql();
        boolean tagExisted = DWMybatisSqlStatementHelper.checkTagExist(boundSql.getSql());
        if (tagExisted) {
            PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
            MappedStatement ms = mpSh.mappedStatement();
            this.processTenantIsolation(ms, boundSql);
        } else {
            super.beforePrepare(sh, connection, transactionTimeout);
        }
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        boolean tagExisted = DWMybatisSqlStatementHelper.checkTagExist(boundSql.getSql());
        if (tagExisted) {
            this.processTenantIsolation(ms, boundSql);
        } else {
            super.beforeQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
        }
    }

    private void processTenantIsolation(StatementHandler sh) {
    }

    private void processTenantIsolation(MappedStatement ms, BoundSql boundSql) {
        SqlCommandType sct = ms.getSqlCommandType();
        StopWatch stopWatch = new StopWatch();
        String sqlId = "";
        String originalSql = "";
        Map<Object, Object> mapperStatamentInfo = new HashMap();
        mapperStatamentInfo = this.getMappedStatementInfo(ms, boundSql);
        if (MapUtils.isNotEmpty(mapperStatamentInfo)) {
            sqlId = mapperStatamentInfo.get("sqlId").toString();
            originalSql = boundSql.getSql();
            stopWatch.start();
            try {
                this.filterSqlStatement(boundSql, mapperStatamentInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug(String.format(_LOGTAG + " %s filterSqlStatement() costs %d (ms)", mapperStatamentInfo.get("sqlId"), stopWatch.getTime()));
            }
            stopWatch.reset();
        }
        if (MapUtils.isNotEmpty(mapperStatamentInfo)) {
            this.writeSqlInfoToServiceContext(originalSql, (List)mapperStatamentInfo.get("sqlParameters"), (IDWSQLOptions)mapperStatamentInfo.get("dw-mybatis-data-option"));
        }
    }

    private void filterSqlStatement(BoundSql boundSql, Map<String, Object> mapperStatementInfo) throws Exception {
        SqlCommandType sqlCommandType = (SqlCommandType)mapperStatementInfo.get("sqlCommandType");
        String sqlCommand = boundSql.getSql();
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug(_LOGTAG + "[filterSqlStatement] TenantEnabled:" + DWTenantUtils.isTenantenabled() + ",before sql command:" + sqlCommand);
        }
        IDWSQLOptions dataOptions = (IDWSQLOptions)MapUtils.getObject(mapperStatementInfo, (Object)"dataOptions", null);
        sqlCommand = this.sqlCommandReplace(sqlCommandType, sqlCommand, dataOptions);
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        field.set(boundSql, sqlCommand);
    }

    private String sqlCommandReplace(SqlCommandType sqlCommandType, String sqlCommand, IDWSQLOptions dataOptions) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantTagDD), _matchQuoteEmpty);
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTagDD), _matchQuoteEmpty);
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTagDD), _matchQuoteEmpty);
        boolean tenantEnabled = DWSQLTenantIsolationFilter.isEnabled((IDWSQLOptions)dataOptions);
        String tenantLogPrefix = _LOGTAG + "[sqlCommandReplace] tenantEnabled(" + tenantEnabled + ") ";
        if (tenantEnabled) {
            sqlCommand = this.covertTenantTag(sqlCommand);
        } else {
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantTagDD), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantNameTagDD), _matchQuoteEmpty);
            Matcher matcher = this.patternTagWithAlias.matcher(sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantValueTagDD), _matchQuoteEmpty));
            if (matcher.find()) {
                sqlCommand = matcher.replaceAll(_matchQuoteEmpty);
            }
        }
        if (_LOGGER.isDebugEnabled()) {
            if (sqlCommand.matches(this.regExCheckTenantTag)) {
                _LOGGER.debug(tenantLogPrefix + " after clean tag, something wrong. Full sql:" + sqlCommand);
            } else {
                _LOGGER.debug(tenantLogPrefix + " after clean tag, " + StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength));
            }
        }
        if (MgmtSqlCommandTypeSet.contains(sqlCommandType)) {
            String mgmtLogPrefix = _LOGTAG + "[sqlCommandReplace] ";
            DWDaoProperties dwDaoProperties = DWDaoProperties.getDefaultProperties();
            if (dwDaoProperties != null && dwDaoProperties.getMgmtFieldProperties().isMgmtFieldEnabled()) {
                boolean mgmtEnabled = DWSQLManagementFieldFilter.isEnabled((IDWSQLOptions)dataOptions);
                mgmtLogPrefix = mgmtLogPrefix + "mgmtEnabled(" + mgmtEnabled + ") ";
                if (mgmtEnabled) {
                    sqlCommand = this.covertMgmtTag(sqlCommand, dataOptions);
                }
            }
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS), _matchQuoteEmpty);
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug(mgmtLogPrefix + " after clean tag, " + StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength));
            }
        }
        return sqlCommand;
    }

    private String getInsertOrUpdateMgmtValueSql(List<Object> insertOrUpdateValues) {
        StringBuffer returnValue = new StringBuffer();
        for (Object rowValue : insertOrUpdateValues) {
            if (rowValue instanceof String) {
                returnValue.append(", '" + rowValue + "' ");
                continue;
            }
            if (rowValue instanceof Date) {
                returnValue.append(", '" + rowValue + "' ");
                continue;
            }
            returnValue.append(", " + rowValue + " ");
        }
        return returnValue.toString();
    }

    public void setProperties(Properties properties) {
        String sqlLogMaxLength = properties.getProperty("sqlLogMaxLength");
        if (NumberUtils.isDigits((String)sqlLogMaxLength)) {
            this.sqlLogMaxLength = NumberUtils.createInteger((String)sqlLogMaxLength);
        }
    }

    public String covertTenantTag(String sqlCommand) {
        Long tenantsid = null;
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile.containsKey(IAM_TENANTSIDKEY)) {
            tenantsid = (Long)profile.get(IAM_TENANTSIDKEY);
        }
        if (DWMybatisSqlStatementHelper.checkTagTenantExist(sqlCommand)) {
            if (tenantsid != null) {
                if (sqlCommand.contains(sqlTenantTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantTagDD), Matcher.quoteReplacement(" and " + tenantColumnName + "= " + tenantsid + " "));
                }
                if (sqlCommand.contains(sqlTenantNameTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantNameTagDD), Matcher.quoteReplacement(", " + tenantColumnName));
                }
                if (sqlCommand.contains(sqlTenantValueTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantValueTagDD), Matcher.quoteReplacement(", " + tenantsid + " "));
                }
                Matcher matcher = this.patternTagWithAlias.matcher(sqlCommand);
                while (matcher.find()) {
                    String source = matcher.group();
                    String target = source.replaceAll(this.basePrefixRegexp, "and ");
                    target = target.replaceAll(this.basePostfixRegexp, " = " + tenantsid);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format(_LOGTAG + " replace '%s' to '%s' ", source, target));
                    }
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(source), target);
                }
            } else {
                throw new DWDataException("13013", String.format("[DWSQLTenantIsolationFilter.doFilter] %s is missing in profile.", tenantColumnName));
            }
        }
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug(_LOGTAG + "[covertTenantTag] result sqlCommand:" + sqlCommand);
        }
        return sqlCommand;
    }

    public String covertMgmtTag(String sqlCommand, IDWSQLOptions dataOptions) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String mgmtFieldResolverClazz = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldResolver();
        Class resolverClass = DWApplicationClassLoader.getInstance().loadClass(mgmtFieldResolverClazz);
        IDWManagementFieldResolver resolver = (IDWManagementFieldResolver)resolverClass.newInstance();
        DWSQLManagementFieldFilter filter = new DWSQLManagementFieldFilter(resolver);
        IDWManagementFieldResolver mgmtFieldResolver = filter.getMgmtFieldResolver();
        CharSequence[] insertFields = mgmtFieldResolver.getInsertFields();
        String[] updateFields = mgmtFieldResolver.getUpdateFields();
        boolean insertFieldCountZero = insertFields.length == 0;
        boolean hasTag = false;
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS)) {
            hasTag = true;
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS), "");
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS)) {
            hasTag = true;
            String replacedColumnString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", insertFields);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS), replacedColumnString);
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS)) {
            hasTag = true;
            String paramValues = this.getInsertOrUpdateMgmtValueSql(mgmtFieldResolver.getInsertFieldValues());
            String replacedParameterString = insertFieldCountZero ? "" : paramValues;
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS), replacedParameterString);
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
            hasTag = true;
            ArrayList<String> columnValueSetList = new ArrayList<String>();
            String updateFieldAliasName = DWMybatisSqlManagementField.getManagementFieldAliasName(dataOptions);
            for (String updateField : updateFields) {
                Object value = mgmtFieldResolver.getFieldValue(updateField);
                String columnValueSet = !"".equals(updateFieldAliasName) ? updateFieldAliasName + "." + updateField + "=" : updateField + "=";
                columnValueSet = columnValueSet + (value == null ? "null" : "'" + value.toString() + "'");
                columnValueSetList.add(columnValueSet);
            }
            String replacedParameterString = (columnValueSetList.size() == 0 ? "" : ", ") + String.join((CharSequence)", ", columnValueSetList);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS), replacedParameterString);
        }
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug(_LOGTAG + String.format("[covertMgmtTag] hasTag(%b), result sqlCommand:%s", hasTag, StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength)));
        }
        return sqlCommand;
    }

    private Map<String, Object> getMappedStatementInfo(MappedStatement mappedStatement, BoundSql boundSql) {
        HashMap<String, Object> statementInfo = new HashMap<String, Object>();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        String sqlId = mappedStatement.getId();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject != null && parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            ArrayList<String> params = new ArrayList<String>();
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (paramValue instanceof IDWSQLOptions) {
                    statementInfo.put("dataOptions", paramValue);
                }
                params.add(entry.toString());
            }
            statementInfo.put("sqlParameters", params);
        }
        statementInfo.put("sqlCommandType", sqlCommandType);
        statementInfo.put("sqlId", sqlId);
        return statementInfo;
    }

    public void writeSqlInfoToServiceContext(String sql, List<Object> parameterMappingList, IDWSQLOptions option) {
        boolean configOfServiceLogForOperate = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && ((Boolean)operateLogMap.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogMap.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = option != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)option.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", parameterMappingList);
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug(String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b, combinedConfigValueOfSqlLogForOperate=%b, daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }
}

