/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class DWMybatistLogOperationSQLInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    protected static final Log _logger = LogFactory.getLog(DWMybatistLogOperationSQLInnerInterceptor.class);
    private static final String _LOGTAG = "[" + DWMybatistLogOperationSQLInnerInterceptor.class.getSimpleName() + "]";

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        BoundSql boundSql = sh.getBoundSql();
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        boolean isLogOperation = this.isLogOperation(boundSql);
        if (isLogOperation) {
            String sql = boundSql.getSql();
            try {
                Map<String, Object> mapperStatamentInfo = this.getMappedStatementInfo(ms, boundSql);
                this.putSqlInfoToContext(sql, mapperStatamentInfo);
            }
            catch (Exception e) {
                _logger.debug(String.format("%s, sql:%s ,exception:%s", _LOGTAG, sql, e.getCause()));
                e.printStackTrace();
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(String.format(_LOGTAG + " isLogOperation  is %b ", isLogOperation));
        }
    }

    private boolean isLogOperation(BoundSql boundSql) {
        DWDataSetOperationOption dataOptions = new DWDataSetOperationOption();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject != null && parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (!(paramValue instanceof IDWSQLOptions)) continue;
                dataOptions = (IDWSQLOptions)paramValue;
                if (!_logger.isDebugEnabled()) break;
                _logger.debug(String.format("%s dataOptions:%s", _LOGTAG, dataOptions.toString()));
                break;
            }
        }
        boolean isLogOperaton = BooleanUtils.toBoolean((Boolean)((Boolean)dataOptions.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED, (Object)true)));
        return isLogOperaton;
    }

    private Map<String, Object> getMappedStatementInfo(MappedStatement mappedStatement, BoundSql boundSql) {
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        String sqlId = mappedStatement.getId();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = mappedStatement.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        ArrayList<Object> paramsForLogOperation = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)parameterMappings)) {
            for (int indexOfParamMapping = 0; indexOfParamMapping < parameterMappings.size(); ++indexOfParamMapping) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(indexOfParamMapping);
                if (parameterMapping.getMode() != ParameterMode.OUT) {
                    Object value;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (parameterObject == null) {
                        value = null;
                    } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                        value = parameterObject;
                    } else {
                        MetaObject metaObject = configuration.newMetaObject(parameterObject);
                        value = metaObject.getValue(propertyName);
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(String.format("%s parameter %d: %s(%s)", _LOGTAG, indexOfParamMapping, value, value.getClass().getName()));
                    }
                    paramsForLogOperation.add(indexOfParamMapping, value);
                    continue;
                }
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug(String.format("%s parameter %d: mode %s", _LOGTAG, indexOfParamMapping, parameterMapping.getMode()));
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(String.format("%s parameterMappings is null or empty", _LOGTAG));
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("sqlParameters", paramsForLogOperation);
        returnData.put("sqlCommandType", sqlCommandType);
        returnData.put("sqlId", sqlId);
        return returnData;
    }

    public void putSqlInfoToContext(String sql, Map<String, Object> mapperStatamentInfo) {
        this.putSqlInfoToContext(sql, (List)mapperStatamentInfo.get("sqlParameters"), (IDWSQLOptions)mapperStatamentInfo.get("dw-mybatis-data-option"));
    }

    private void putSqlInfoToContext(String sql, List<Object> parameterMappingList, IDWSQLOptions option) {
        boolean configOfServiceLogForOperate = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && ((Boolean)operateLogMap.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogMap.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = option != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)option.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", parameterMappingList);
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b , combinedConfigValueOfSqlLogForOperate=%b , daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }
}

