/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.utils;

import com.digiwin.app.dao.mybatis.DWMybatisIgnore;
import java.util.HashMap;
import java.util.Map;

public class DWMybatisIgnoreTenantUtil {
    static ThreadLocal<Map<Object, Boolean>> tenantIgnoreLocal = new ThreadLocal();

    public static boolean isIgnore(String tableName) {
        DWMybatisIgnoreTenantUtil.checkAndInit();
        return tenantIgnoreLocal.get().containsKey((Object)DWMybatisIgnore.ALL) || tenantIgnoreLocal.get().containsKey(tableName);
    }

    public static boolean bindIgnoreTable(String tableName) {
        DWMybatisIgnoreTenantUtil.checkAndInit();
        tenantIgnoreLocal.get().put(tableName, true);
        return true;
    }

    public static boolean unbindIgnoreTable(String tableName) {
        DWMybatisIgnoreTenantUtil.checkAndInit();
        tenantIgnoreLocal.get().remove(tableName);
        return true;
    }

    public static void clearIgnoreTables() {
        DWMybatisIgnoreTenantUtil.checkAndInit();
        tenantIgnoreLocal.get().clear();
    }

    public static void checkAndInit() {
        Map<Object, Boolean> ignoreTable = tenantIgnoreLocal.get();
        if (ignoreTable == null) {
            ignoreTable = new HashMap<Object, Boolean>();
            tenantIgnoreLocal.set(ignoreTable);
        }
    }
}

