/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.persistconn.TenantIdProvider;
import com.digiwin.app.persistconn.client.DWPersistconnClient;
import com.digiwin.app.persistconn.client.InvokeDapService;
import com.digiwin.app.persistconn.client.InvokeOtherDapService;
import com.digiwin.app.persistconn.client.InvokeSaasService;
import com.digiwin.app.persistconn.client.InvokeTenantDapService;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import com.digiwin.app.persistconn.client.QueryEaiRegister;
import com.digiwin.app.persistconn.client.QueryRegister;
import com.digiwin.app.persistconn.client.ReRegister;
import com.digiwin.app.persistconn.client.Register;
import com.digiwin.app.persistconn.client.SendConfig;
import com.digiwin.app.persistconn.client.SendData;
import com.digiwin.app.persistconn.client.SendMessage;
import com.digiwin.app.queue.Command;
import com.digiwin.app.queue.DWQueueProducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class DWPersistconnClientBuilder {
    private static final String SAAS_TENANT_ID = "saas";
    private static final String SAAS_GATEWAY_ID = "saas";
    private Flow _flow;
    private Target _target;
    private Command _command;
    private String _tenantId;
    private String _gatewayId;
    private List<String> _gatewayIds;
    private Integer _timeout;
    private TimeUnit _timeoutUnit;
    private Map<String, DWQueueProducer.CompleteCallback> _customBroadcastCompleteCallbacks;
    private Map<String, DWQueueProducer.TimeoutCallback> _customBroadcastTimeoutCallbacks;
    private String _localPath;
    private String _fileName;
    private String _extension;
    private String _message;
    private DWQueueProducer.CompleteCallback _customCompleteCallback;
    private DWQueueProducer.TimeoutCallback _customTimeoutCallback;
    private String _apName;
    private String _moduleName;
    private String _serviceName;
    private String _methodName;
    private Map<String, Object> _parameter;

    public DWPersistconnClientBuilder() {
        String tenantId;
        this._tenantId = tenantId = TenantIdProvider.getTenantId();
    }

    public ToSaasCommand toSaas() {
        this._target = Target.SAAS;
        return new ToSaasCommand();
    }

    public ToTenantCommand toTenant() {
        this._target = Target.TENANT;
        return new ToTenantCommand();
    }

    private List<String> queryRegister() {
        DWPersistconnClient persistconnClient = new DWPersistconnClientBuilder().toSaas().queryRegister(this._message).build();
        String result = "[]";
        try {
            result = persistconnClient.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONArray ja = new JSONArray(result);
        ArrayList<String> gatewayIds = new ArrayList<String>();
        for (int i = 0; i < ja.length(); ++i) {
            gatewayIds.add(ja.getString(i));
        }
        return gatewayIds;
    }

    public class Builder {
        public DWPersistconnClient build() {
            switch (DWPersistconnClientBuilder.this._command) {
                case INVOKE_DAP_SERVICE: {
                    return new InvokeDapService(DWPersistconnClientBuilder.this._apName, DWPersistconnClientBuilder.this._moduleName, DWPersistconnClientBuilder.this._serviceName, DWPersistconnClientBuilder.this._methodName, DWPersistconnClientBuilder.this._parameter);
                }
                case INVOKE_THIS_DAP_SERVICE: {
                    return new InvokeThisDapService(DWPersistconnClientBuilder.this._moduleName, DWPersistconnClientBuilder.this._serviceName, DWPersistconnClientBuilder.this._methodName, DWPersistconnClientBuilder.this._parameter);
                }
                case INVOKE_OTHER_DAP_SERVICE: {
                    return new InvokeOtherDapService(DWPersistconnClientBuilder.this._apName, DWPersistconnClientBuilder.this._moduleName, DWPersistconnClientBuilder.this._serviceName, DWPersistconnClientBuilder.this._methodName, DWPersistconnClientBuilder.this._parameter);
                }
                case INVOKE_SAAS_SERVICE: {
                    return new InvokeSaasService(DWPersistconnClientBuilder.this._apName, DWPersistconnClientBuilder.this._moduleName, DWPersistconnClientBuilder.this._serviceName, DWPersistconnClientBuilder.this._methodName, DWPersistconnClientBuilder.this._parameter);
                }
                case INVOKE_TENANT_DAP_SERVICE: {
                    String invokeTenantServiceTopic = DWPersistconnClientBuilder.this._tenantId + "." + DWPersistconnClientBuilder.this._gatewayId + "." + Command.INVOKE_TENANT_DAP_SERVICE.toString();
                    switch (DWPersistconnClientBuilder.this._flow) {
                        case SYNC: {
                            return new InvokeTenantDapService(invokeTenantServiceTopic, DWPersistconnClientBuilder.this._message, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback, DWPersistconnClientBuilder.this._flow);
                        }
                        case ASYNC: {
                            return new InvokeTenantDapService(invokeTenantServiceTopic, DWPersistconnClientBuilder.this._message, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback, DWPersistconnClientBuilder.this._flow);
                        }
                    }
                    return null;
                }
                case SEND_MESSAGE: {
                    if (Target.SAAS.equals((Object)DWPersistconnClientBuilder.this._target)) {
                        DWPersistconnClientBuilder.this._tenantId = "saas";
                    }
                    String sendMessageTopic = DWPersistconnClientBuilder.this._tenantId + "." + DWPersistconnClientBuilder.this._gatewayId + "." + Command.SEND_MESSAGE.toString();
                    return new SendMessage(sendMessageTopic, DWPersistconnClientBuilder.this._message, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback);
                }
                case REGISTER: {
                    return new Register(DWPersistconnClientBuilder.this._message);
                }
                case REREGISTER: {
                    return new ReRegister(DWPersistconnClientBuilder.this._message);
                }
                case BROADCAST: {
                    ArrayList<String> broadcastTopics = new ArrayList<String>();
                    for (String gatewayId : DWPersistconnClientBuilder.this._gatewayIds) {
                        String broadcastTopic = DWPersistconnClientBuilder.this._tenantId + "." + gatewayId + "." + Command.BROADCAST.toString();
                        broadcastTopics.add(broadcastTopic);
                    }
                    return new SendConfig(broadcastTopics, DWPersistconnClientBuilder.this._message, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback, DWPersistconnClientBuilder.this._customBroadcastCompleteCallbacks, DWPersistconnClientBuilder.this._customBroadcastTimeoutCallbacks);
                }
                case SEND_CONFIG: {
                    ArrayList<String> sendConfigTopics = new ArrayList<String>();
                    for (String gatewayId : DWPersistconnClientBuilder.this._gatewayIds) {
                        String sendConfigTopic = DWPersistconnClientBuilder.this._tenantId + "." + gatewayId + "." + Command.SEND_CONFIG.toString();
                        sendConfigTopics.add(sendConfigTopic);
                    }
                    return new SendConfig(sendConfigTopics, DWPersistconnClientBuilder.this._message, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback, DWPersistconnClientBuilder.this._customBroadcastCompleteCallbacks, DWPersistconnClientBuilder.this._customBroadcastTimeoutCallbacks);
                }
                case QUERY_REGISTER: {
                    String queryRegisterTopic = "saas.saas." + Command.QUERY_REGISTER.toString();
                    return new QueryRegister(queryRegisterTopic, DWPersistconnClientBuilder.this._message);
                }
                case QUERY_EAI_REGISTER: {
                    return new QueryEaiRegister(DWPersistconnClientBuilder.this._tenantId);
                }
                case SEND_DATA: {
                    if (Target.SAAS.equals((Object)DWPersistconnClientBuilder.this._target)) {
                        DWPersistconnClientBuilder.this._tenantId = "saas";
                    }
                    String sendDataTopic = DWPersistconnClientBuilder.this._tenantId + "." + DWPersistconnClientBuilder.this._gatewayId + "." + Command.SEND_DATA.toString();
                    return new SendData(sendDataTopic, DWPersistconnClientBuilder.this._timeout, DWPersistconnClientBuilder.this._timeoutUnit, DWPersistconnClientBuilder.this._customCompleteCallback, DWPersistconnClientBuilder.this._customTimeoutCallback, DWPersistconnClientBuilder.this._localPath, DWPersistconnClientBuilder.this._fileName, DWPersistconnClientBuilder.this._extension);
                }
            }
            return null;
        }
    }

    public class FlowSetter {
        public Builder Sync() {
            DWPersistconnClientBuilder.this._flow = Flow.SYNC;
            return new CallbackSetter().noCustomCallback();
        }

        public CallbackSetter Async() {
            DWPersistconnClientBuilder.this._flow = Flow.ASYNC;
            return new CallbackSetter();
        }
    }

    public class BroadcastCallbackSetter {
        public Builder customCallback(Map<String, DWQueueProducer.CompleteCallback> customBroadcastCompleteCallbacks, Map<String, DWQueueProducer.TimeoutCallback> customBroadcastTimeoutCallbacks) {
            DWPersistconnClientBuilder.this._customBroadcastCompleteCallbacks = customBroadcastCompleteCallbacks;
            DWPersistconnClientBuilder.this._customBroadcastTimeoutCallbacks = customBroadcastTimeoutCallbacks;
            return new Builder();
        }

        public Builder noCustomCallback() {
            DWPersistconnClientBuilder.this._customBroadcastCompleteCallbacks = new HashMap();
            DWPersistconnClientBuilder.this._customBroadcastTimeoutCallbacks = new HashMap();
            return new Builder();
        }
    }

    public class CallbackSetter {
        public Builder customCallback(DWQueueProducer.CompleteCallback customCompleteCallback, DWQueueProducer.TimeoutCallback customTimeoutCallback) {
            DWPersistconnClientBuilder.this._customCompleteCallback = customCompleteCallback;
            DWPersistconnClientBuilder.this._customTimeoutCallback = customTimeoutCallback;
            return new Builder();
        }

        public Builder customCallback(DWQueueProducer.CompleteCallback customCompleteCallback) {
            return this.customCallback(customCompleteCallback, null);
        }

        public Builder customCallback(DWQueueProducer.TimeoutCallback customTimeoutCallback) {
            return this.customCallback(null, customTimeoutCallback);
        }

        public Builder noCustomCallback() {
            return this.customCallback(null, null);
        }
    }

    public class ToTenantCommand {
        public ToDapCommand toDap() {
            return new ToDapCommand();
        }

        public FlowSetter invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) throws Exception {
            DWPersistconnClientBuilder.this._command = Command.INVOKE_TENANT_DAP_SERVICE;
            DWPersistconnClientBuilder.this._gatewayId = gatewayId;
            JSONObject jo = new JSONObject();
            jo.put("apName", (Object)apName);
            jo.put("moduleName", (Object)moduleName);
            jo.put("serviceName", (Object)serviceName);
            jo.put("methodName", (Object)methodName);
            jo.put("parameter", (Object)DWGsonProvider.getGson().toJson(parameter, parameter.getClass()));
            DWPersistconnClientBuilder.this._message = jo.toString();
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new FlowSetter();
        }

        public FlowSetter invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
            return this.invokeTenantDapService(gatewayId, apName, moduleName, serviceName, methodName, parameter, -1, TimeUnit.SECONDS);
        }

        public CallbackSetter sendMessage(String gatewayId, String message, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.SEND_MESSAGE;
            DWPersistconnClientBuilder.this._gatewayId = gatewayId;
            DWPersistconnClientBuilder.this._message = message;
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new CallbackSetter();
        }

        public CallbackSetter sendMessage(String gatewayId, String message) {
            return this.sendMessage(gatewayId, message, -1, TimeUnit.SECONDS);
        }

        public CallbackSetter sendData(String gatewayId, String localPath, String fileName, String extension, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.SEND_DATA;
            DWPersistconnClientBuilder.this._gatewayId = gatewayId;
            DWPersistconnClientBuilder.this._localPath = localPath;
            DWPersistconnClientBuilder.this._fileName = fileName;
            DWPersistconnClientBuilder.this._extension = extension;
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new CallbackSetter();
        }

        public CallbackSetter sendData(String gatewayId, String localPath, String fileName, String extension) {
            return this.sendData(gatewayId, localPath, fileName, extension, -1, TimeUnit.SECONDS);
        }

        public BroadcastCallbackSetter broadcast(String message, Integer timeout, TimeUnit timeoutUnit) {
            List gatewayIds = DWPersistconnClientBuilder.this.queryRegister();
            return this.broadcast(gatewayIds, message, timeout, timeoutUnit);
        }

        public BroadcastCallbackSetter broadcast(List<String> gatewayIds, String message, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.BROADCAST;
            DWPersistconnClientBuilder.this._gatewayIds = gatewayIds;
            DWPersistconnClientBuilder.this._message = message;
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new BroadcastCallbackSetter();
        }

        public BroadcastCallbackSetter broadcast(String message) {
            return this.broadcast(message, -1, TimeUnit.SECONDS);
        }

        public BroadcastCallbackSetter broadcast(List<String> gatewayIds, String message) {
            return this.broadcast(gatewayIds, message, -1, TimeUnit.SECONDS);
        }

        public BroadcastCallbackSetter sendConfig(List<String> gatewayIds, Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.SEND_CONFIG;
            DWPersistconnClientBuilder.this._gatewayIds = gatewayIds;
            DWPersistconnClientBuilder.this._message = new JSONObject(parameter).toString();
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new BroadcastCallbackSetter();
        }

        public BroadcastCallbackSetter sendConfig(List<String> gatewayIds, Map<String, Object> parameter) {
            return this.sendConfig(gatewayIds, parameter, -1, TimeUnit.SECONDS);
        }

        public BroadcastCallbackSetter sendConfig(Map<String, Object> parameter) {
            List gatewayIds = DWPersistconnClientBuilder.this.queryRegister();
            return this.sendConfig(gatewayIds, parameter, -1, TimeUnit.SECONDS);
        }

        public BroadcastCallbackSetter sendConfig(Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) {
            List gatewayIds = DWPersistconnClientBuilder.this.queryRegister();
            return this.sendConfig(gatewayIds, parameter, timeout, timeoutUnit);
        }
    }

    public class ToSaasCommand {
        public Builder invokeSaasService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
            DWPersistconnClientBuilder.this._command = Command.INVOKE_SAAS_SERVICE;
            DWPersistconnClientBuilder.this._apName = apName;
            DWPersistconnClientBuilder.this._moduleName = moduleName;
            DWPersistconnClientBuilder.this._serviceName = serviceName;
            DWPersistconnClientBuilder.this._methodName = methodName;
            DWPersistconnClientBuilder.this._parameter = parameter;
            return new Builder();
        }

        public Builder queryRegister(String apName) {
            DWPersistconnClientBuilder.this._command = Command.QUERY_REGISTER;
            DWPersistconnClientBuilder.this._message = DWPersistconnClientBuilder.this._tenantId + "." + apName;
            return new Builder();
        }

        public Builder queryEaiRegister() {
            DWPersistconnClientBuilder.this._command = Command.QUERY_EAI_REGISTER;
            return new Builder();
        }

        public CallbackSetter sendMessage(String message, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.SEND_MESSAGE;
            DWPersistconnClientBuilder.this._gatewayId = "saas";
            DWPersistconnClientBuilder.this._message = message;
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new CallbackSetter();
        }

        public CallbackSetter sendMessage(String message) {
            return this.sendMessage(message, -1, TimeUnit.SECONDS);
        }

        public Builder register(String userId, String password, String gatewayName, String apName) {
            DWPersistconnClientBuilder.this._command = Command.REGISTER;
            DWPersistconnClientBuilder.this._message = userId + "." + password + "." + gatewayName + "." + apName;
            return new Builder();
        }

        public Builder reRegister(String gatewayId, String gatewayName, String apName) {
            DWPersistconnClientBuilder.this._command = Command.REREGISTER;
            DWPersistconnClientBuilder.this._message = DWPersistconnClientBuilder.this._tenantId + "." + gatewayId + "." + gatewayName + "." + apName;
            return new Builder();
        }

        public CallbackSetter sendData(String localPath, String fileName, String extension, Integer timeout, TimeUnit timeoutUnit) {
            DWPersistconnClientBuilder.this._command = Command.SEND_DATA;
            DWPersistconnClientBuilder.this._gatewayId = "saas";
            DWPersistconnClientBuilder.this._localPath = localPath;
            DWPersistconnClientBuilder.this._fileName = fileName;
            DWPersistconnClientBuilder.this._extension = extension;
            DWPersistconnClientBuilder.this._timeout = timeout;
            DWPersistconnClientBuilder.this._timeoutUnit = timeoutUnit;
            return new CallbackSetter();
        }

        public CallbackSetter sendData(String localPath, String fileName, String extension) {
            return this.sendData(localPath, fileName, extension, -1, TimeUnit.SECONDS);
        }
    }

    public class ToDapCommand {
        public Builder invokeDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
            DWPersistconnClientBuilder.this._command = Command.INVOKE_DAP_SERVICE;
            DWPersistconnClientBuilder.this._apName = apName;
            DWPersistconnClientBuilder.this._moduleName = moduleName;
            DWPersistconnClientBuilder.this._serviceName = serviceName;
            DWPersistconnClientBuilder.this._methodName = methodName;
            DWPersistconnClientBuilder.this._parameter = parameter;
            return new Builder();
        }

        public Builder invokeThisDapService(String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
            DWPersistconnClientBuilder.this._command = Command.INVOKE_THIS_DAP_SERVICE;
            DWPersistconnClientBuilder.this._moduleName = moduleName;
            DWPersistconnClientBuilder.this._serviceName = serviceName;
            DWPersistconnClientBuilder.this._methodName = methodName;
            DWPersistconnClientBuilder.this._parameter = parameter;
            return new Builder();
        }

        public Builder invokeOtherDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) {
            DWPersistconnClientBuilder.this._command = Command.INVOKE_OTHER_DAP_SERVICE;
            DWPersistconnClientBuilder.this._apName = apName;
            DWPersistconnClientBuilder.this._moduleName = moduleName;
            DWPersistconnClientBuilder.this._serviceName = serviceName;
            DWPersistconnClientBuilder.this._methodName = methodName;
            DWPersistconnClientBuilder.this._parameter = parameter;
            return new Builder();
        }
    }

    public static enum Flow {
        SYNC,
        ASYNC;

    }

    public static enum Target {
        SAAS,
        TENANT,
        DAP;

    }
}

