/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.util;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.persistconn.TokenProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class DapHttpRequestUtil {
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static CloseableHttpClient httpClient;

    public String httpInvoke(String url, Map<String, Object> parameters) throws Exception {
        String token = TokenProvider.getToken();
        String appToken = TokenProvider.getAppToken();
        String originIamUrlKeyFromHeader = TokenProvider.getOriginIamUrlKeyFromHeader();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("token", token);
        httpPost.addHeader("digi-middleware-auth-app", appToken);
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKeyFromHeader)) {
            httpPost.addHeader("origin-iam-url-key", originIamUrlKeyFromHeader);
        }
        String jsonString = DWGsonProvider.getGson().toJson(parameters, parameters.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = "";
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                String string = result;
                return string;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                result = stringBuffer.toString();
            }
        }
        return result;
    }

    public String crossCloudHttpInvoke(String url, Map<String, Object> parameters) throws Exception {
        String token = TokenProvider.getToken();
        String appToken = TokenProvider.getAppToken();
        String originIamUrlKey = TokenProvider.getOriginIamUrlKey();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("token", token);
        httpPost.addHeader("digi-middleware-auth-app", appToken);
        httpPost.addHeader("origin-iam-url-key", originIamUrlKey);
        String jsonString = DWGsonProvider.getGson().toJson(parameters, parameters.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = "";
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                String string = result;
                return string;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                result = stringBuffer.toString();
            }
        }
        return result;
    }

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(500);
        manager.setDefaultMaxPerRoute(500);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
        IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
        monitor.start();
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        this.manager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

