/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.IAMIdentityService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TokenProvider {
    private static String _token = "";

    public static String getToken() throws Exception {
        String token = DWServiceContext.getContext().getToken();
        if (!StringUtils.isBlank((CharSequence)token)) {
            return token;
        }
        if (!StringUtils.isBlank((CharSequence)_token)) {
            return _token;
        }
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile.containsKey("secretKey")) {
            String secretKey = String.valueOf(profile.get("secretKey"));
            IAMIdentityService iamIdentityService = (IAMIdentityService)SpringContextUtils.getBean((String)"dwIAMIdentityService");
            String tokenBySecretKey = iamIdentityService.getToken(secretKey);
            return tokenBySecretKey;
        }
        return _token;
    }

    public static void setToken(String token) {
        _token = token;
    }

    public static String getOriginIamUrlKeyFromHeader() {
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault("origin-iam-url-key", "");
        return originIamUrlKey;
    }

    public static String getOriginIamUrlKeyFromConfig() {
        String originIamUrlKey = DWApplicationConfigUtils.getProperty((String)"originIamUrlKey", (String)"");
        return originIamUrlKey;
    }

    public static String getOriginIamUrlKey() {
        String originIamUrlKey = TokenProvider.getOriginIamUrlKeyFromHeader();
        if (StringUtils.isBlank((CharSequence)originIamUrlKey)) {
            originIamUrlKey = TokenProvider.getOriginIamUrlKeyFromConfig();
        }
        return originIamUrlKey;
    }

    public static String getAppToken() {
        String originIamUrlKeyFromHeader = TokenProvider.getOriginIamUrlKeyFromHeader();
        String appToken = "";
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKeyFromHeader)) {
            appToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        } else {
            appToken = System.getProperty("appToken", "");
            if (!StringUtils.isBlank((CharSequence)appToken)) {
                return appToken;
            }
            appToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        }
        return appToken;
    }
}

