/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.persistconn.util.HttpRequestFuse;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.context.ApplicationContext;

public class DapHttpRequestUtil {
    private static Log log = LogFactory.getLog(DapHttpRequestUtil.class);
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";

    public String httpInvoke(String key, String url, Map<String, Object> parameters) throws Exception {
        String token = TokenProvider.getToken();
        String appToken = TokenProvider.getAppToken();
        String originIamUrlKeyFromHeader = TokenProvider.getOriginIamUrlKeyFromHeader();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("token", token);
        httpPost.addHeader("digi-middleware-auth-app", appToken);
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKeyFromHeader)) {
            httpPost.addHeader("origin-iam-url-key", originIamUrlKeyFromHeader);
        }
        String jsonString = DWGsonProvider.getGson().toJson(parameters, parameters.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        OutboundConfig outboundConfig = this.getOutboundConfig(key);
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[ServiceClient] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[ServiceClient] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        HttpRequestFuse httpRequestFuse = new HttpRequestFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("httpPost", (Object)httpPost);
        DWFuseReturnResponse response = new DWFuseReturnResponse((Object)"");
        DWFuseOption option = this.getOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[ServiceClient] option: " + option));
        response = DWFuseExecutor.execute((DWReturnFuse)httpRequestFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        String result = (String)response.getResponse();
        return result;
    }

    public String crossCloudHttpInvoke(String key, String url, Map<String, Object> parameters) throws Exception {
        String token = TokenProvider.getToken();
        String appToken = TokenProvider.getAppToken();
        String originIamUrlKey = TokenProvider.getOriginIamUrlKey();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("token", token);
        httpPost.addHeader("digi-middleware-auth-app", appToken);
        httpPost.addHeader("origin-iam-url-key", originIamUrlKey);
        String jsonString = DWGsonProvider.getGson().toJson(parameters, parameters.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        OutboundConfig outboundConfig = this.getOutboundConfig(key);
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[ServiceClient] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[ServiceClient] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        HttpRequestFuse httpRequestFuse = new HttpRequestFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("httpPost", (Object)httpPost);
        DWFuseReturnResponse response = new DWFuseReturnResponse((Object)"");
        response = DWFuseExecutor.execute((DWReturnFuse)httpRequestFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig);
        String result = (String)response.getResponse();
        return result;
    }

    private DWFuseOption getOption() {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = DWApplicationConfigUtils.getProperty((String)isIgnoreUnassignedXRateLimitHeaderKey, (String)String.valueOf(true));
        String isXRateLimitHeaderOn = DWApplicationConfigUtils.getProperty((String)isXRateLimitHeaderOnKey, (String)String.valueOf(true));
        String isCollectMetrics = DWApplicationConfigUtils.getProperty((String)isCollectMetricsKey, (String)String.valueOf(false));
        String isAutoFuseHttpStatusCode = DWApplicationConfigUtils.getProperty((String)isAutoFuseHttpStatusCodeKey, (String)String.valueOf(true));
        String inboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)inboundErrorHttpStatusCodeKey, (String)String.valueOf(429));
        String outboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)outboundErrorHttpStatusCodeKey, (String)String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        return option;
    }

    private OutboundConfig getOutboundConfig(String key) {
        key = "serviceClient." + key;
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = DWApplicationConfigUtils.getProperty((String)enableKey, null);
        String failureRate = DWApplicationConfigUtils.getProperty((String)failureRateKey, null);
        String openSec = DWApplicationConfigUtils.getProperty((String)openSecKey, null);
        String halfOpenCalculateSize = DWApplicationConfigUtils.getProperty((String)halfOpenCalculateSizeKey, null);
        String closeCalculateSize = DWApplicationConfigUtils.getProperty((String)closeCalculateSizeKey, null);
        if (StringUtils.isBlank((CharSequence)enable)) {
            enable = DWApplicationConfigUtils.getProperty((String)DapPropertiesOutboundKey.enable((String)"serviceClient"), (String)"false");
        }
        if (StringUtils.isBlank((CharSequence)failureRate)) {
            failureRate = DWApplicationConfigUtils.getProperty((String)DapPropertiesOutboundKey.failureRate((String)"serviceClient"), (String)String.valueOf(50));
        }
        if (StringUtils.isBlank((CharSequence)openSec)) {
            openSec = DWApplicationConfigUtils.getProperty((String)DapPropertiesOutboundKey.openSec((String)"serviceClient"), (String)String.valueOf(60));
        }
        if (StringUtils.isBlank((CharSequence)halfOpenCalculateSize)) {
            halfOpenCalculateSize = DWApplicationConfigUtils.getProperty((String)DapPropertiesOutboundKey.halfOpenCalculateSize((String)"serviceClient"), (String)String.valueOf(10));
        }
        if (StringUtils.isBlank((CharSequence)closeCalculateSize)) {
            closeCalculateSize = DWApplicationConfigUtils.getProperty((String)DapPropertiesOutboundKey.closeCalculateSize((String)"serviceClient"), (String)String.valueOf(100));
        }
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }
}

