/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.client;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.client.DWRpcClient;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.digiwin.gateway.result.DWResultHandlerList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class InvokeThisDapService
extends DWRpcClient {
    private String moduleName;
    private String serviceName;
    private String methodName;
    private Map<String, Object> parameters;

    public InvokeThisDapService(DWResourcePojo pojo) {
        this.moduleName = pojo.getModuleName();
        this.serviceName = pojo.getServiceName();
        this.methodName = pojo.getMethodName();
        this.parameters = pojo.getParameters();
    }

    @Override
    public String invoke() throws Exception {
        HashMap profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = new HashMap();
        }
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        try {
            Object result = containerContext.invoke(this.moduleName, this.serviceName, this.methodName, (DWParameters)new DWDefaultParameters(this.parameters), profile);
            DWResultHandlerList handler = DWResultHandlerList.getInstance();
            result = handler.process(result);
            return (String)result;
        }
        catch (Throwable e) {
            HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            if (e instanceof DWException) {
                httpStatus = HttpStatus.BAD_REQUEST;
            }
            Map standardErrorMessage = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)e);
            String standardResult = DWGsonProvider.getGson().toJson((Object)standardErrorMessage, standardErrorMessage.getClass());
            return standardResult;
        }
    }
}

