/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn;

import com.digiwin.app.persistconn.DWQueueConfiguration;
import com.digiwin.app.persistconn.DWQueueProperties;
import com.digiwin.processor.enums.KeyStoreEnum;
import com.digiwin.queue.saas.SaasClient;
import com.digiwin.queue.tenant.TenantClient;
import org.apache.commons.lang3.StringUtils;

public class DWQueueClientProvider {
    private static SaasClient saasClient = null;
    private static TenantClient tenantClient = null;
    private static int retryTimes = -1;
    private static long retryIntervalSec = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaasClient getSaasClient() throws Exception {
        if (saasClient != null) return saasClient;
        Class<SaasClient> clazz = SaasClient.class;
        synchronized (SaasClient.class) {
            if (saasClient != null) return saasClient;
            DWQueueProperties properties = DWQueueConfiguration.getProperties();
            String host = properties.getSaasRabbitmqHost();
            int amqpPort = properties.getSaasRabbitmqAmqpPort();
            int httpPort = properties.getSaasRabbitmqHttpPort();
            String username = properties.getSaasRabbitmqUsername();
            String password = properties.getSaasRabbitmqPassword();
            properties.validate();
            SaasClient.Protocol protocol = properties.isSaasRabbitmqIsHttps() ? SaasClient.Protocol.HTTPS : SaasClient.Protocol.HTTP;
            saasClient = retryTimes <= 0 || retryIntervalSec <= 0L ? SaasClient.init((SaasClient.Protocol)protocol, (String)host, (Integer)amqpPort, (Integer)httpPort, (String)username, (String)password) : SaasClient.init((SaasClient.Protocol)protocol, (String)host, (Integer)amqpPort, (Integer)httpPort, (String)username, (String)password, (int)retryTimes, (long)retryIntervalSec);
            if (!properties.isQueueSaasTlsOn()) return saasClient;
            if (host.toLowerCase().endsWith(".cn")) {
                saasClient.openSSL(KeyStoreEnum.ALIYUN);
            }
            if (!host.toLowerCase().endsWith(".com")) return saasClient;
            saasClient.openSSL(KeyStoreEnum.AZURE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return saasClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantClient getTenantClient() throws Exception {
        if (tenantClient != null) return tenantClient;
        DWQueueProperties properties = DWQueueConfiguration.getProperties();
        String host = properties.getTenantProcessorHost();
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new Exception("\u9577\u9023\u63a5Tenant\u8a2d\u5b9a\u7570\u5e38(host)");
        }
        Class<TenantClient> clazz = TenantClient.class;
        synchronized (TenantClient.class) {
            if (tenantClient != null) return tenantClient;
            tenantClient = retryTimes <= 0 || retryIntervalSec <= 0L ? TenantClient.init((String)host) : TenantClient.init((String)host, (Integer)retryTimes, (Long)retryIntervalSec);
            if (!properties.isTenantTlsOn()) return tenantClient;
            if (host.toLowerCase().endsWith(".cn")) {
                tenantClient.openSSL(KeyStoreEnum.ALIYUN);
            }
            if (!host.toLowerCase().endsWith(".com")) return tenantClient;
            tenantClient.openSSL(KeyStoreEnum.AZURE);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tenantClient;
        }
    }

    public static void setRetryTimes(int retryTimes) {
        DWQueueClientProvider.retryTimes = retryTimes;
    }

    public static void setRetryIntervalSec(int retryIntervalSec) {
        DWQueueClientProvider.retryIntervalSec = retryIntervalSec;
    }
}

