/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.queue.DWQueueApplicationContextProvider;
import com.digiwin.app.queue.DWQueueConsumer;
import com.digiwin.app.queue.DWQueueSaasProducer;
import com.digiwin.app.queue.DWQueueTenantProducer;
import com.digiwin.app.queue.DWQueueTopicManager;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqChannel;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqClientHolder;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqConsumer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqQueueDeclarer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqSaasProducer;
import com.digiwin.app.queue.rabbitmq.DWRabbitmqTenantProducer;
import com.digiwin.app.queue.rabbitmq.Heartbeat;
import com.rabbitmq.client.ConnectionFactory;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"Saas", "Tenant"})
public class DWQueueConfiguration {
    private static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");

    private static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    @Bean
    @Profile(value={"Saas"})
    public DWQueueApplicationContextProvider publicCloudApplicationContextProvider() {
        return new DWQueueApplicationContextProvider("Saas");
    }

    @Bean
    @Profile(value={"Tenant"})
    public DWQueueApplicationContextProvider privateCloudApplicationContextProvider() {
        return new DWQueueApplicationContextProvider("Tenant");
    }

    @Bean
    public ConnectionFactory connectionFactory() throws Exception {
        String host = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqHost", (String)"");
        String username = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqUsername", (String)"");
        String password = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqPassword", (String)"");
        int handshakeTimeout = Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"queueRabbitmqHandshakeTimeout", (String)"10"));
        int tcpConnectionTimeout = Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"queueRabbitmqTcpConnectionTimeout", (String)"60"));
        int heartbeat = Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"queueRabbitmqHeartbeat", (String)"60"));
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(host);
        factory.setUsername(username);
        factory.setPassword(password);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setTopologyRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        factory.setHandshakeTimeout(handshakeTimeout * 1000);
        factory.setConnectionTimeout(tcpConnectionTimeout * 1000);
        factory.setRequestedHeartbeat(heartbeat);
        return factory;
    }

    @Bean(name={"QueueDeclarer"})
    public DWRabbitmqQueueDeclarer queueDeclarer() {
        return new DWRabbitmqQueueDeclarer();
    }

    @Bean
    public DWRabbitmqChannel rabbitmqChannel() {
        return new DWRabbitmqChannel();
    }

    @Bean
    public DWQueueConsumer queueConsumer() {
        return new DWRabbitmqConsumer();
    }

    @Bean(name={"TopicManager"})
    public DWQueueTopicManager topicManager() {
        return new DWQueueTopicManager();
    }

    @Bean
    public DWRabbitmqClientHolder clientHolder() throws Exception {
        String host = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqHost", (String)"");
        if (DWQueueConfiguration.isIpPattern(host)) {
            host = host + ":15672";
        }
        String url = "http://" + host + "/api/consumers";
        String username = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqUsername", (String)"");
        String password = DWApplicationConfigUtils.getProperty((String)"queueRabbitmqPassword", (String)"");
        return new DWRabbitmqClientHolder(url, username, password);
    }

    @Bean
    @Profile(value={"Heartbeat"})
    @DependsOn(value={"QueueDeclarer"})
    public Heartbeat heartbeat() throws Exception {
        String rate = DWApplicationConfigUtils.getProperty((String)"queueHeartbeatRate");
        return new Heartbeat(Long.valueOf(rate));
    }

    @Configuration
    @Profile(value={"Tenant"})
    public static class TenantConfiguration {
        @Bean
        @DependsOn(value={"QueueDeclarer", "TopicManager"})
        public DWQueueTenantProducer tenantProducer() {
            return new DWRabbitmqTenantProducer();
        }
    }

    @Configuration
    @Profile(value={"Saas"})
    public static class SaasConfiguration {
        @Bean
        @DependsOn(value={"QueueDeclarer", "TopicManager"})
        public DWQueueSaasProducer saasProducer() {
            return new DWRabbitmqSaasProducer();
        }
    }
}

