/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.BlockingQueue;
import org.json.JSONObject;

public abstract class DWQueueReceiver {
    private BlockingQueue<JSONObject> response;
    private String receiverId;

    public abstract void onReceive(String var1);

    public DWQueueReceiver(String receiverId) {
        this.receiverId = receiverId;
    }

    public void onSuccess() {
        this.onSuccess("");
    }

    public void onSuccess(String response) {
        JSONObject jo = new JSONObject();
        jo.put("receiverId", (Object)this.receiverId);
        jo.put("result", true);
        jo.put("response", (Object)response);
        this.response.offer(jo);
    }

    public void onFail() {
        this.onFail("");
    }

    public void onFail(String response) {
        JSONObject jo = new JSONObject();
        jo.put("receiverId", (Object)this.receiverId);
        jo.put("result", false);
        jo.put("response", (Object)response);
        this.response.offer(jo);
    }

    public void execute(String message) {
        try {
            this.onReceive(message);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.onFail(stringWriter.toString());
        }
    }

    public void setResponse(BlockingQueue<JSONObject> response) {
        this.response = response;
    }

    public String getReceiverId() {
        return this.receiverId;
    }
}

