/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue;

import com.digiwin.app.queue.DWQueueReceiver;
import java.util.ArrayList;
import java.util.List;

public class NamespaceNode {
    private List<DWQueueReceiver> receivers = new ArrayList<DWQueueReceiver>();
    private String id = null;
    private boolean isWildcard = false;
    private List<NamespaceNode> children = new ArrayList<NamespaceNode>();
    private NamespaceNode parent = null;

    public void addNamespace(String namespace, DWQueueReceiver receiver) {
        String[] ids = namespace.split("\\.");
        NamespaceNode currentNode = this;
        for (int i = 0; i < ids.length; ++i) {
            currentNode = currentNode.addChild(ids[i]);
        }
        currentNode.setReceiver(receiver);
    }

    public NamespaceNode addChild(String id) {
        for (NamespaceNode child : this.children) {
            if (!child.getId().equals(id)) continue;
            return child;
        }
        NamespaceNode child = new NamespaceNode();
        child.setParent(this);
        child.setId(id);
        if ("#".equals(id)) {
            child.setWildcard(true);
        }
        this.children.add(child);
        return child;
    }

    public List<NamespaceNode> getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private void setParent(NamespaceNode parent) {
        this.parent = parent;
    }

    public NamespaceNode getParent() {
        return this.parent;
    }

    public List<DWQueueReceiver> getReceivers() {
        return this.receivers;
    }

    public void setReceiver(DWQueueReceiver receiver) {
        this.receivers.add(receiver);
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public void setWildcard(boolean isWildcard) {
        this.isWildcard = isWildcard;
    }
}

