/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.queue;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.app.queue.NamespaceNode;
import java.util.ArrayList;
import java.util.List;

public class NamespaceParser {
    public static synchronized void updateByReceiverId(NamespaceNode node, String receiverId) {
        NamespaceParser.updateByReceiverId(node, 0, receiverId);
    }

    private static void updateByReceiverId(NamespaceNode node, int index, String receiverId) {
        List<NamespaceNode> children = node.getChildren();
        for (NamespaceNode child : children) {
            List<DWQueueReceiver> receivers = child.getReceivers();
            ArrayList<DWQueueReceiver> targets = new ArrayList<DWQueueReceiver>();
            for (DWQueueReceiver receiver : receivers) {
                if (!receiver.getReceiverId().equals(receiverId)) continue;
                targets.add(receiver);
            }
            receivers.removeAll(targets);
            if (child.getChildren().size() == 0) continue;
            NamespaceParser.updateByReceiverId(child, ++index, receiverId);
        }
    }

    public static synchronized List<DWQueueReceiver> query(NamespaceNode node, String namespace) {
        String[] ids = namespace.split("\\.");
        return NamespaceParser.query(node, 0, ids);
    }

    private static List<DWQueueReceiver> query(NamespaceNode node, int index, String[] ids) {
        List<NamespaceNode> children = node.getChildren();
        if (index + 1 == ids.length) {
            String id = ids[index];
            if ("#".equals(id)) {
                ArrayList<DWQueueReceiver> receivers = new ArrayList<DWQueueReceiver>();
                NamespaceParser.queryWildcard(node, receivers);
                return receivers;
            }
            ArrayList<DWQueueReceiver> receivers = new ArrayList<DWQueueReceiver>();
            for (NamespaceNode child : children) {
                if (child.getId().equals(id)) {
                    receivers.addAll(child.getReceivers());
                }
                if (!"#".equals(child.getId())) continue;
                NamespaceParser.queryWildcard(node, receivers);
            }
            return receivers;
        }
        for (NamespaceNode child : children) {
            if (!ids[index].equals(child.getId())) continue;
            return NamespaceParser.query(child, ++index, ids);
        }
        return new ArrayList<DWQueueReceiver>();
    }

    private static void queryWildcard(NamespaceNode node, List<DWQueueReceiver> receivers) {
        List<NamespaceNode> children = node.getChildren();
        for (NamespaceNode child : children) {
            receivers.addAll(child.getReceivers());
            NamespaceParser.queryWildcard(child, receivers);
        }
    }
}

