/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redis.service.impl;

import com.digiwin.app.redis.service.IDWRedisService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.CollectionUtils;

public class DWRedisService
implements IDWRedisService {
    private static Log log = LogFactory.getLog(DWRedisService.class);
    private RedisTemplate<String, Object> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public void remove(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    @Override
    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public Object getHashValue(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public Map<Object, Object> getHash(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public boolean setHash(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean setHash(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean setHashValue(String key, String hashKey, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean setHashValue(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public void removeHashValue(String key, Object ... hashKey) {
        this.redisTemplate.opsForHash().delete((Object)key, hashKey);
    }

    @Override
    public boolean hasHashKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    @Override
    public long getHashSize(String key) {
        try {
            return this.redisTemplate.opsForHash().size((Object)key);
        }
        catch (Exception e) {
            log.error((Object)e);
            return 0L;
        }
    }

    @Override
    public Set<String> keys(String pattern) {
        HashSet<String> result = new HashSet<String>();
        Set<Object> scanResults = this.scan(pattern);
        for (Object scanResult : scanResults) {
            result.add(String.valueOf(scanResult));
        }
        return result;
    }

    public Set<Object> scan(final String pattern) {
        Set execute = (Set)this.redisTemplate.execute((RedisCallback)new RedisCallback<Set<Object>>(){

            public Set<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                HashSet<Object> binaryKeys = new HashSet<Object>();
                Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().match(pattern + "*").count(Integer.MAX_VALUE).build());
                while (cursor.hasNext()) {
                    binaryKeys.add(new String((byte[])cursor.next()));
                }
                return binaryKeys;
            }
        });
        return execute;
    }

    @Override
    public long incrBy(String key, long num) {
        Long result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.increment((Object)key, num);
        return result;
    }
}

