/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redis;

import com.digiwin.app.redis.DWRedisSetting;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class DWRedis {
    private JedisPool _jedisPool;

    public DWRedis(String redisName, String csvSetting) {
        DWRedisSetting redisSetting = new DWRedisSetting(redisName, csvSetting);
        this.generateJedisPool(redisSetting);
    }

    public Jedis getJedis() {
        return this._jedisPool.getResource();
    }

    public void onDestory() {
        this._jedisPool.close();
    }

    private void generateJedisPool(DWRedisSetting redisSetting) {
        String host = redisSetting.getHost();
        int port = redisSetting.getPort();
        int timeout = redisSetting.getTimeout();
        int maxTotal = redisSetting.getMaxTotal();
        int maxIdle = redisSetting.getMaxIdle();
        int maxWaitMillis = redisSetting.getMaxWaitMillis();
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(maxTotal);
        jedisPoolConfig.setMaxIdle(maxIdle);
        jedisPoolConfig.setMaxWaitMillis((long)maxWaitMillis);
        this._jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeout);
    }
}

