/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.resource;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class DWResourceBundleUtils {
    private static Log _log = LogFactory.getLog(DWResourceBundleUtils.class);
    public static final String KEY_LOCALE = "locale";

    public static String getString(ClassLoader cl, String baseName, String key, Object ... patternArguments) {
        return DWResourceBundleUtils.getString(cl, baseName, DWResourceBundleUtils.getCurrentLocale(), key, patternArguments);
    }

    public static String getString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        ResourceBundle rb = null;
        String result = null;
        try {
            rb = ResourceBundle.getBundle(baseName, locale, cl);
            if (rb != null) {
                result = rb.getString(key);
            }
        }
        catch (MissingResourceException exception) {
            _log.debug((Object)(DWResourceBundleUtils.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
        }
        if (result == null) {
            result = DWResourceBundleUtils.getNotFoundString(baseName, key);
            patternArguments = null;
        }
        if (patternArguments != null) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    static String getNotFoundString(String baseName, String key) {
        return String.format("baseName[%s], key[%s] not found!", baseName, key);
    }

    @Deprecated
    public static String getResourceBundle(ClassLoader cl, String baseName, Locale locale, String key, String defaultValue, Object ... patternArguments) {
        ResourceBundle rb = null;
        String result = null;
        try {
            rb = ResourceBundle.getBundle(baseName, locale, cl);
            if (rb != null) {
                result = rb.getString(key);
            }
        }
        catch (MissingResourceException exception) {
            _log.debug((Object)(DWResourceBundleUtils.class.getName() + " resource bundle " + baseName + ", key " + key + " not found"));
        }
        if (result == null) {
            if (defaultValue == null) {
                result = String.format("baseName[%s], key[%s] not found!", baseName, key);
                patternArguments = null;
            } else {
                result = defaultValue;
            }
        }
        if (patternArguments != null) {
            result = String.format(result, patternArguments);
        }
        return result;
    }

    @Deprecated
    public static String getResourceBundle(ClassLoader cl, String baseName, String key, String defaultValue, Object ... patternArguments) {
        return DWResourceBundleUtils.getResourceBundle(cl, baseName, DWResourceBundleUtils.getCurrentLocale(), key, defaultValue, patternArguments);
    }

    public static Locale getCurrentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static Locale getLocale(String localeString) {
        String[] parts = localeString.split("_");
        String lang = parts[0];
        String country = parts.length > 1 ? parts[1] : "";
        Locale locale = new Locale(lang, country);
        return locale;
    }
}

