/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.restful;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRestInvocationException;
import com.digiwin.app.http.HttpRequestModel;
import com.digiwin.app.http.HttpRequester;
import com.digiwin.app.http.HttpResponseModel;
import com.digiwin.app.http.ServiceModel;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.DWServiceContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;

public class DWRestfulProxy
implements InvocationHandler {
    private DWService _reference;

    public DWRestfulProxy(DWService reference) {
        this._reference = reference;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        DWServiceContext serviceContext = DWServiceContext.getContext();
        DWServiceContext.getContext().setFuture(null);
        Object result = null;
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)serviceContext.getModuleName());
        Thread.currentThread().setContextClassLoader((ClassLoader)moduleClassLoader);
        StringBuffer sb = new StringBuffer();
        sb.append("/restful/service/");
        sb.append(serviceContext.getModuleName());
        sb.append("/");
        sb.append(method.getDeclaringClass().getSimpleName());
        sb.append("/");
        sb.append(method.getName());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int index = 0;
        for (Parameter param : method.getParameters()) {
            paramMap.put(param.getName(), arguments[index]);
            ++index;
        }
        HttpResponseModel responseModel = (HttpResponseModel)DWRestfulProxy.invokeRestService(sb.toString(), paramMap, serviceContext.getToken());
        Map returnMap = (Map)DWGsonProvider.getGson().fromJson(responseModel.getResponseBody(), HashMap.class);
        result = DWGsonProvider.getGson().fromJson(DWGsonProvider.getGson().toJson(returnMap.get("response")), method.getReturnType());
        return result;
    }

    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = DWRestfulProxy.createRequestHeader(model);
        String requestBody = DWRestfulProxy.createRequestBody(model.getParams());
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setUrl(DWApplicationConfigUtils.getProperty((String)"k8sProxyUrl") + model.getInvokeURL());
        requestModel.setContentType(DWApplicationConfigUtils.getProperty((String)"k8sProxyContentType"));
        requestModel.setCharSet(DWApplicationConfigUtils.getProperty((String)"k8sProxyCharset"));
        requestModel.setConnectionPoolRequestTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"k8sProxyHttpConnectionPoolRequestTimeout")));
        requestModel.setConnectionTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"k8sProxyHttpConnectionTimeout")));
        requestModel.setSoTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"k8sProxySoTimeout")));
        requestModel.setEncode(DWApplicationConfigUtils.getProperty((String)"k8sProxyEncode"));
        requestModel.setMaxTotalConnections(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"k8sProxyHttpMaxConnections")));
        HttpResponseModel responseModel = HttpRequester.submitRequest(requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            DWRestfulProxy.handleHttpStatus(responseModel);
        }
        return responseModel;
    }

    public static String createRequestBody(Map<String, Object> params) throws Exception {
        String content = DWGsonProvider.getGson().toJson(params);
        return content;
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", DWApplicationConfigUtils.getProperty((String)"k8sProxyContentType") + ";" + DWApplicationConfigUtils.getProperty((String)"k8sProxyCharset"));
        header.put("token", model.getToken());
        return header;
    }

    public static void handleHttpStatus(HttpResponseModel responseModel) throws Exception {
        Map returnMap = (Map)DWGsonProvider.getGson().fromJson(responseModel.getResponseBody(), HashMap.class);
        DWRestInvocationException restInvocationException = new DWRestInvocationException(null != ((Map)returnMap.get("debugInfo")).get("stackTrace") ? ((Map)returnMap.get("debugInfo")).get("stackTrace").toString() : "");
        restInvocationException.setErrorInstructors(null != returnMap.get("errorInstructors") ? (Map)returnMap.get("errorInstructors") : null);
        restInvocationException.setErrorType(null != returnMap.get("errorType") ? ((Map)returnMap.get("errorType")).toString() : "");
        restInvocationException.setStatus(responseModel.getHttpStatusCode());
        restInvocationException.setStatusDescription(null != returnMap.get("statusDescription") ? ((Map)returnMap.get("statusDescription")).toString() : "");
        throw restInvocationException;
    }

    public static Object invokeRestService(String invokeURL, Map<String, Object> params, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setToken(token);
        Object returnObj = DWRestfulProxy.submit(serviceModel);
        return returnObj;
    }
}

