/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.http.HttpResponseModel;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class DWRestfulContainerFuse
implements DWReturnFuse<HttpResponseModel> {
    private static Log log = LogFactory.getLog(DWRestfulContainerFuse.class);

    public HttpResponseModel execute(DWFuseParameter fuseParameter) throws Exception {
        CloseableHttpClient client = (CloseableHttpClient)fuseParameter.get("client");
        HttpPost post = (HttpPost)fuseParameter.get("post");
        String responseBody = "";
        int statusCode = -1;
        try (Object response = client.execute((HttpUriRequest)post);){
            statusCode = response.getStatusLine().getStatusCode();
            try (InputStream responseStream = response.getEntity().getContent();){
                if (responseStream != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                }
            }
        }
        if (statusCode == 429 || statusCode == 502 || statusCode == 503 || statusCode == 504) {
            log.warn((Object)("[DWRestfulContainerFuse] HTTP Status Code: " + statusCode + ", result: " + responseBody));
            throw new DWServerErrorException(statusCode, responseBody);
        }
        response = new HttpResponseModel(statusCode, responseBody);
        return response;
    }
}

