/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.http.DWRestfulContainerFuse;
import com.digiwin.app.http.HttpConnectionManager;
import com.digiwin.app.http.HttpRequestLogModel;
import com.digiwin.app.http.HttpRequestLogger;
import com.digiwin.app.http.HttpRequestModel;
import com.digiwin.app.http.HttpResponseModel;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;
import org.springframework.context.ApplicationContext;

public class HttpRequester {
    private static Log log = LogFactory.getLog(HttpRequester.class);

    public static HttpResponseModel submitRequest(final HttpRequestModel requestModel) throws Exception {
        HttpRequestLogModel logModel = new HttpRequestLogModel();
        logModel.setUrl(requestModel.getUrl());
        logModel.setRequestHeader(requestModel.getRequestHeader());
        logModel.setRequestBody(requestModel.getRequestBody());
        CloseableHttpClient client = HttpConnectionManager.getHttpClient(requestModel);
        HttpPost post = new HttpPost(requestModel.getUrl());
        Args.notNull((Object)requestModel.getRequestBody(), (String)"Source string");
        post.setEntity((HttpEntity)new AbstractHttpEntity(requestModel.getContentType(), requestModel.getEncode(), false){
            private final byte[] content;
            {
                super(contentType, contentEncoding, chunked);
                this.content = requestModel.getRequestBody().getBytes("UTF-8");
            }

            public final boolean isRepeatable() {
                return true;
            }

            public final long getContentLength() {
                return this.content.length;
            }

            public final InputStream getContent() throws IOException {
                return new ByteArrayInputStream(this.content);
            }

            public final void writeTo(OutputStream outStream) throws IOException {
                Args.notNull((Object)outStream, (String)"Output stream");
                outStream.write(this.content);
                outStream.flush();
            }

            public final boolean isStreaming() {
                return false;
            }

            public final void close() throws IOException {
            }
        });
        for (Map.Entry<String, String> header : requestModel.getRequestHeader().entrySet()) {
            post.addHeader(header.getKey(), (Object)header.getValue());
        }
        logModel.setStartTime(LocalDateTime.now());
        OutboundConfig outboundConfig = HttpRequester.getOutboundConfig();
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWRestfulContainer] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWRestfulContainer] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWRestfulContainerFuse restfulContainerFuse = new DWRestfulContainerFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("client", (Object)client);
        fuseParameter.set("post", (Object)post);
        DWFuseReturnResponse fuseReturn = new DWFuseReturnResponse((Object)new HttpResponseModel(-1, ""));
        DWFuseOption option = DWFuseOption.getDefaultOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWRestfulContainer] option: " + String.valueOf(option)));
        fuseReturn = DWFuseExecutor.execute((DWReturnFuse)restfulContainerFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        HttpResponseModel response = (HttpResponseModel)fuseReturn.getResponse();
        String responseBody = response.getResponseBody();
        int httpStatusCode = response.getHttpStatusCode();
        logModel.setEndTime(LocalDateTime.now());
        logModel.setResponseBody(responseBody);
        logModel.setHttpStatusCode(httpStatusCode);
        HttpRequestLogger.log(logModel);
        HttpResponseModel responseModel = new HttpResponseModel(httpStatusCode, responseBody);
        return responseModel;
    }

    private static OutboundConfig getOutboundConfig() {
        String key = "restfulContainer";
        return OutboundConfig.create((String)key);
    }
}

