/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.job;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.schedule.util.DWScheduleServiceContextUtil;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.iam.HttpResponseModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class DWJobInvoker
implements Job,
InterruptableJob {
    private static boolean remoteInvocation = "true".equalsIgnoreCase(DWApplicationConfigUtils.getProperty((String)"scheduleRemoteInvocation", (String)"false"));

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        boolean isExclude = jobDataMap.getBoolean("isExclude");
        if (isExclude) {
            return;
        }
        String moduleName = jobDataMap.getString("module_name");
        String serviceName = jobDataMap.getString("job_name");
        Map paramMap = (Map)jobDataMap.get((Object)"schedule_param");
        if (StringUtils.isEmpty((CharSequence)moduleName) || StringUtils.isEmpty((CharSequence)serviceName)) {
            throw new JobExecutionException("\u8a2d\u5b9a\u7570\u5e38");
        }
        Map<String, Object> profile = DWScheduleServiceContextUtil.initProfile(jobDataMap);
        try {
            DWJobResult result;
            if (remoteInvocation) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("paramMap", paramMap);
                result = this.remoteInvoke(moduleName, serviceName, "executeJob", parameters, profile);
            } else {
                DWDefaultParameters parameters = new DWDefaultParameters();
                parameters.put("paramMap", (Object)paramMap);
                DWContainerContext containerContext = DWContainerContext.getInstance();
                result = (DWJobResult)containerContext.invoke(moduleName, serviceName, "executeJob", (DWParameters)parameters, profile);
            }
            jobDataMap.put("execute_status", result == null ? "" : result.getExecuteStatus());
            jobDataMap.put("message", result == null ? "" : result.getMessage());
            jobDataMap.put("message_detail", result == null ? "" : result.getMessageDetail());
        }
        catch (Exception e) {
            Throwable exception = this.getCause(e);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            String exeErrorDetailMsg = stringWriter.toString();
            jobDataMap.put("execute_status", "error");
            jobDataMap.put("message", exception.getMessage());
            jobDataMap.put("message_detail", exeErrorDetailMsg);
        }
    }

    private DWJobResult remoteInvoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters, Map<String, Object> profile) throws Exception {
        DWJobResult result = null;
        HttpResponseModel responseModel = DWInnerInvocationUtils.innerInvoke((String)moduleName, (String)serviceName, (String)methodName, parameters, profile);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            DWInnerInvokeResponseFailedException ex = new DWInnerInvokeResponseFailedException(responseModel.getResponseBody(), httpStatusCode);
            ex.statusCode = httpStatusCode;
            throw ex;
        }
        String responseBody = responseModel.getResponseBody();
        DWJobInnerInvocationResult invocationResult = (DWJobInnerInvocationResult)DWInnerInvocationUtils.getGson().fromJson(responseBody, DWJobInnerInvocationResult.class);
        result = invocationResult.getResponse();
        return result;
    }

    public void interrupt() throws UnableToInterruptJobException {
    }

    private Throwable getCause(Throwable e) {
        Throwable cause = null;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    private class DWJobInnerInvocationResult {
        private DWJobResult response;

        private DWJobInnerInvocationResult() {
        }

        public DWJobResult getResponse() {
            return this.response;
        }
    }

    private class DWInnerInvokeResponseFailedException
    extends Exception {
        private int statusCode;

        DWInnerInvokeResponseFailedException(String message, int statusCode) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

