/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.jdbcjobstore;

import com.digiwin.app.schedule.quartz.delegate.DWStdJDBCDelegate;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;

public class DWJobStore
extends JobStoreTX {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobStoreSupport.RecoverMisfiredJobsResult doRecoverMisfires() throws JobPersistenceException {
        boolean transOwner = false;
        Connection conn = this.getNonManagedTXConnection();
        boolean recovering = false;
        try {
            int maxMisfiresToHandleAtATime = recovering ? -1 : this.getMaxMisfiresToHandleAtATime();
            LinkedList<TriggerKey> misfiredTriggers = new LinkedList<TriggerKey>();
            long earliestNewTime = Long.MAX_VALUE;
            DWStdJDBCDelegate delegate = (DWStdJDBCDelegate)this.getDelegate();
            boolean hasMoreMisfiredTriggers = delegate.hasDWMisfiredTriggersInState(conn, "WAITING", this.getMisfireTime(), maxMisfiresToHandleAtATime, misfiredTriggers);
            if (hasMoreMisfiredTriggers) {
                this.getLog().info("Handling the first " + misfiredTriggers.size() + " triggers that missed their scheduled fire-time.  " + "More misfired triggers remain to be processed.");
            } else if (misfiredTriggers.size() > 0) {
                this.getLog().info("Handling " + misfiredTriggers.size() + " trigger(s) that missed their scheduled fire-time.");
            } else {
                this.getLog().debug("Found 0 triggers that missed their scheduled fire-time.");
                JobStoreSupport.RecoverMisfiredJobsResult recoverMisfiredJobsResult = JobStoreSupport.RecoverMisfiredJobsResult.NO_OP;
                return recoverMisfiredJobsResult;
            }
            for (TriggerKey triggerKey : misfiredTriggers) {
                OperableTrigger trig = this.retrieveTrigger(conn, triggerKey);
                if (trig == null) continue;
                String isMisfire = "true";
                trig.getJobDataMap().put("is_misfire", isMisfire);
                Field schedSignalerField = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredField("schedSignaler");
                schedSignalerField.setAccessible(true);
                SchedulerSignaler schedSignaler = (SchedulerSignaler)schedSignalerField.get((Object)this);
                this.doUpdateOfMisfiredTrigger(schedSignaler, conn, trig, false, "WAITING", recovering);
                if (trig.getNextFireTime() == null || trig.getNextFireTime().getTime() >= earliestNewTime) continue;
                earliestNewTime = trig.getNextFireTime().getTime();
            }
            JobStoreSupport.RecoverMisfiredJobsResult result = new JobStoreSupport.RecoverMisfiredJobsResult(hasMoreMisfiredTriggers, misfiredTriggers.size(), earliestNewTime);
            this.commitConnection(conn);
            JobStoreSupport.RecoverMisfiredJobsResult recoverMisfiredJobsResult = result;
            return recoverMisfiredJobsResult;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        catch (SQLException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Database error recovering from misfires.", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected runtime exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.rollbackConnection(conn);
            throw new JobPersistenceException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.releaseLock("TRIGGER_ACCESS", transOwner);
            }
            finally {
                this.cleanupConnection(conn);
            }
        }
    }

    private void doUpdateOfMisfiredTrigger(SchedulerSignaler schedSignaler, Connection conn, OperableTrigger trig, boolean forceState, String newStateIfNotComplete, boolean recovering) throws JobPersistenceException {
        Calendar cal = null;
        if (trig.getCalendarName() != null) {
            cal = this.retrieveCalendar(conn, trig.getCalendarName());
        }
        schedSignaler.notifyTriggerListenersMisfired((Trigger)trig);
        trig.updateAfterMisfire(cal);
        if (trig.getNextFireTime() == null) {
            this.storeMisfiredTrigger(conn, trig, null, true, "COMPLETE", forceState, recovering);
            schedSignaler.notifySchedulerListenersFinalized((Trigger)trig);
        } else {
            this.storeMisfiredTrigger(conn, trig, null, true, newStateIfNotComplete, forceState, recovering);
        }
    }

    private void storeMisfiredTrigger(Connection conn, OperableTrigger newTrigger, JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws JobPersistenceException {
        boolean existingTrigger = this.triggerExists(conn, newTrigger.getKey());
        if (existingTrigger && !replaceExisting) {
            throw new ObjectAlreadyExistsException((Trigger)newTrigger);
        }
        try {
            DWStdJDBCDelegate delegate = (DWStdJDBCDelegate)this.getDelegate();
            if (!forceState) {
                boolean shouldBepaused = delegate.isTriggerGroupPaused(conn, newTrigger.getKey().getGroup());
                if (!shouldBepaused && (shouldBepaused = delegate.isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    delegate.insertPausedTriggerGroup(conn, newTrigger.getKey().getGroup());
                }
                if (shouldBepaused && (state.equals("WAITING") || state.equals("ACQUIRED"))) {
                    state = "PAUSED";
                }
            }
            if (job == null) {
                job = this.retrieveJob(conn, newTrigger.getJobKey());
            }
            if (job == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            if (job.isConcurrentExectionDisallowed() && !recovering) {
                state = this.checkBlockedState(conn, job.getKey(), state);
            }
            if (existingTrigger) {
                delegate.updateMisfiredTrigger(conn, newTrigger, state, job);
            } else {
                delegate.insertMisfiredTrigger(conn, newTrigger, state, job);
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't store trigger '" + newTrigger.getKey() + "' for '" + newTrigger.getJobKey() + "' job:" + e.getMessage(), (Throwable)e);
        }
    }
}

