/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.context;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWI18NExceptionUtils;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWDataTableCollection;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.service.DWJobService;
import com.digiwin.app.schedule.service.DWScheduleService;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import com.digiwin.app.service.DWServiceContext;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.quartz.ObjectAlreadyExistsException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DWScheduleContext {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleContext]";
    private final Log log = LogFactory.getLog((String)"[DWSchedule.DWScheduleContext]");
    private static DWScheduleContext instance = null;
    private DWScheduleDBService scheduleDBService = DWScheduleDBService.getInstance();
    private DWScheduleTimeDBService scheduleTimeDBService = DWScheduleTimeDBService.getInstance();
    private DWScheduleRecordDBService scheduleRecordDBService = DWScheduleRecordDBService.getInstance();
    private DWScheduleContactDBService scheduleContactDBService = DWScheduleContactDBService.getInstance();
    private DWScheduleService scheduleService = DWScheduleService.getInstance();
    private DWJobService jobService = DWJobService.getInstance();

    public static synchronized DWScheduleContext getInstance() {
        if (instance == null) {
            instance = SpringContextUtils.containsBean((String)"DWScheduleContext") ? (DWScheduleContext)SpringContextUtils.getBean((String)"DWScheduleContext") : new DWScheduleContext();
        }
        return instance;
    }

    public Object executeJob(DWScheduleQuartzInfo quartzInfo) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("executeJob");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
            HashMap<String, String> masterResponseMap = new HashMap<String, String>();
            try {
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("executeJob");
                masterResponseMap.put("response", "no action");
                this.log.info((Object)"[DWSchedule.DWScheduleContext] executeJob: master -> no action");
                totalResponseMap.put("master", masterResponseMap);
                totalResponseMap.putAll(workerResponseMap);
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] executeJob message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] executeJob stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
            }
            return totalResponseMap;
        }
        try {
            String ScheduleId;
            if (DistributedScheduleUtils.isWorker() && !DistributedScheduleUtils.isExecuteWorker(ScheduleId = quartzInfo.getScheduleId())) {
                this.log.info((Object)"[DWSchedule.DWScheduleContext] executeJob: worker -> no action");
                return "no action";
            }
            Boolean result = this.scheduleService.executeJob(quartzInfo);
            return result;
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] executeJob message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] executeJob stack trace: " + stackTrace));
            return false;
        }
    }

    public Object executeSchedule(String scheduleId, String jobName) {
        Boolean result = false;
        try {
            result = this.scheduleService.executeSchedule(scheduleId, jobName);
        }
        catch (Exception e) {
            result = false;
            this.log.error((Object)e.getMessage());
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object addSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("addSchedule");
            return response;
        }
        Boolean result = true;
        DWDataSet dataSet = new DWDataSet();
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleDataSet(dataSet, quartzInfo, "C");
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleTimeDataSet(dataSet, quartzInfo, "C");
        List<ScheduleContactDO> contactList = quartzInfo.getContactList();
        dataSet = DWScheduleCastUtils.convertScheduleContactDOListToDataSet(dataSet, contactList, "C");
        String enableStatus = quartzInfo.getEnableStatus();
        try {
            this.scheduleDBService.updateScheduleByDataSet(dataSet);
            switch (Integer.parseInt(quartzInfo.getScheduleType())) {
                case 1: {
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                    }
                    break;
                }
                case 2: {
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addSchedulePeriodically(quartzInfo);
                    }
                    break;
                }
                case 3: {
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                    }
                    break;
                }
                case 4: {
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                    }
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] addSchedule message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] addSchedule stack trace: " + stackTrace));
            throw e;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
            HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
            try {
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("addSchedule");
                masterResponseMap.put("response", result);
                totalResponseMap.put("master", masterResponseMap);
                totalResponseMap.putAll(workerResponseMap);
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] addSchedule message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] addSchedule stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
            }
            return totalResponseMap;
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object updateScheduleExcludeEnableStatus(DWScheduleQuartzInfo quartzInfo) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("updateScheduleExcludeEnableStatus");
            return response;
        }
        try {
            String scheduleId = quartzInfo.getScheduleId();
            DWDataRow scheduleDataRow = this.scheduleDBService.getScheduleInfo(scheduleId);
            if (scheduleDataRow == null) {
                DWI18NExceptionUtils.throwDWException((String)"12001", (Object[])new Object[]{scheduleId});
            }
            quartzInfo.setEnableStatus((String)scheduleDataRow.get("enable_status"));
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] updateScheduleExcludeEnableStatus message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] updateScheduleExcludeEnableStatus stack trace: " + stackTrace));
            DWI18NExceptionUtils.throwDWException((Throwable)e, (String)"12003", (Object[])new Object[0]);
        }
        return this.updateSchedule(quartzInfo);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object updateSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("updateSchedule");
            return response;
        }
        Boolean result = true;
        DWDataSet dataSet = new DWDataSet();
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleDataSet(dataSet, quartzInfo, "U");
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleTimeDataSet(dataSet, quartzInfo, "U");
        List<ScheduleContactDO> contactList = quartzInfo.getContactList();
        dataSet = DWScheduleCastUtils.convertScheduleContactDOListToDataSet(dataSet, contactList, "U");
        String enableStatus = quartzInfo.getEnableStatus();
        try {
            this.scheduleDBService.updateScheduleByDataSet(dataSet);
            switch (Integer.parseInt(quartzInfo.getScheduleType())) {
                case 1: {
                    this.scheduleService.removeSchedule(quartzInfo);
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                    }
                    break;
                }
                case 2: {
                    this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addSchedulePeriodically(quartzInfo);
                    }
                    break;
                }
                case 3: {
                    this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                    }
                    break;
                }
                case 4: {
                    this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                    if (enableStatus.equals("Y")) {
                        this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                    }
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] updateSchedule message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] updateSchedule stack trace: " + stackTrace));
            throw e;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
            HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
            try {
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("updateSchedule");
                masterResponseMap.put("response", result);
                totalResponseMap.put("master", masterResponseMap);
                totalResponseMap.putAll(workerResponseMap);
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] updateSchedule message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] updateSchedule stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
            }
            return totalResponseMap;
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteSchedule(List<String> scheduleIdList) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("removeSchedule");
            return response;
        }
        Boolean result = true;
        try {
            for (String scheduleId : scheduleIdList) {
                this.scheduleService.deleteJob(scheduleId);
                this.scheduleDBService.deleteSchedule(scheduleId);
                this.scheduleTimeDBService.deleteScheduleTime(scheduleId);
                this.scheduleContactDBService.deleteScheduleContact(scheduleId);
            }
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] removeSchedule message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] removeSchedule stack trace: " + stackTrace));
            throw e;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
            HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
            try {
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("removeSchedule");
                masterResponseMap.put("response", result);
                totalResponseMap.put("master", masterResponseMap);
                totalResponseMap.putAll(workerResponseMap);
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] removeSchedule message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] removeSchedule stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
            }
            return totalResponseMap;
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object setScheduleStatus(String status, List<String> scheduleIdList) throws Exception {
        Boolean result = true;
        if ("Y".equals(status)) {
            if (DistributedScheduleUtils.isAp()) {
                Object response = DistributedScheduleUtils.redirectDwsysAsAp("enableSchedule");
                return response;
            }
            try {
                for (String scheduleId : scheduleIdList) {
                    DWDataRow scheduleDataSet = this.scheduleDBService.getScheduleInfo(scheduleId);
                    if (scheduleDataSet == null) {
                        DWI18NExceptionUtils.throwDWException((String)"12001", (Object[])new Object[]{scheduleId});
                    }
                    if ("Y".equals(scheduleDataSet.get("enable_status"))) continue;
                    DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertDataRowToScheduleQuartzInfo(scheduleDataSet);
                    DWDataRow scheduleTimeDataSet = this.scheduleTimeDBService.getScheduleTimeInfo(scheduleId);
                    ScheduleTimeDO timeDo = DWScheduleCastUtils.convertDataRowToScheduleTimeDo(scheduleTimeDataSet);
                    quartzInfo.setDetail(timeDo);
                    List queryContact = (List)this.scheduleContactDBService.queryScheduleContactList(scheduleId);
                    List<ScheduleContactDO> contactList = DWScheduleCastUtils.convertToScheduleContactList(queryContact);
                    quartzInfo.setContactList(contactList);
                    this.scheduleDBService.enableSchedule(scheduleId);
                    try {
                        switch (Integer.parseInt(quartzInfo.getScheduleType())) {
                            case 1: {
                                this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                                break;
                            }
                            case 2: {
                                this.scheduleService.addSchedulePeriodically(quartzInfo);
                                break;
                            }
                            case 3: {
                                this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                                break;
                            }
                            case 4: {
                                this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                                break;
                            }
                            default: {
                                result = false;
                                break;
                            }
                        }
                    }
                    catch (ObjectAlreadyExistsException e) {
                        String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                        this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule message: " + e.getMessage()));
                        this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule stack trace: " + stackTrace));
                        DWI18NExceptionUtils.throwDWException((Throwable)e, (String)"12002", (Object[])new Object[]{scheduleId});
                    }
                }
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule stack trace: " + stackTrace));
                DWI18NExceptionUtils.throwDWException((Throwable)e, (String)"12003", (Object[])new Object[0]);
            }
            if (DistributedScheduleUtils.isHigherMaster()) {
                HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
                HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
                try {
                    Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("enableSchedule");
                    masterResponseMap.put("response", result);
                    totalResponseMap.put("master", masterResponseMap);
                    totalResponseMap.putAll(workerResponseMap);
                }
                catch (Exception e) {
                    String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule message: " + e.getMessage()));
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] enableSchedule stack trace: " + stackTrace));
                    masterResponseMap.put("response", stackTrace);
                    totalResponseMap.put("master", masterResponseMap);
                }
                return totalResponseMap;
            }
        } else {
            String stackTrace;
            if (DistributedScheduleUtils.isAp()) {
                Object response = DistributedScheduleUtils.redirectDwsysAsAp("disableSchedule");
                return response;
            }
            for (String scheduleId : scheduleIdList) {
                try {
                    this.scheduleDBService.disableSchedule(scheduleId);
                    this.scheduleService.deleteJob(scheduleId);
                }
                catch (Exception e) {
                    stackTrace = DistributedScheduleUtils.getStackTrace(e);
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] disableSchedule message: " + e.getMessage()));
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] disableSchedule stack trace: " + stackTrace));
                    DWI18NExceptionUtils.throwDWException((Throwable)e, (String)"12003", (Object[])new Object[0]);
                }
            }
            if (DistributedScheduleUtils.isHigherMaster()) {
                HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
                HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
                try {
                    Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("disableSchedule");
                    masterResponseMap.put("response", result);
                    totalResponseMap.put("master", masterResponseMap);
                    totalResponseMap.putAll(workerResponseMap);
                }
                catch (Exception e) {
                    stackTrace = DistributedScheduleUtils.getStackTrace(e);
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] disableSchedule message: " + e.getMessage()));
                    this.log.error((Object)("[DWSchedule.DWScheduleContext] disableSchedule stack trace: " + stackTrace));
                    masterResponseMap.put("response", stackTrace);
                    totalResponseMap.put("master", masterResponseMap);
                }
                return totalResponseMap;
            }
        }
        return result;
    }

    public Object getScheduleInfo(String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("getScheduleInfo");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            try {
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("getScheduleInfo");
                Set<Map.Entry<String, Map>> entrySet = workerResponseMap.entrySet();
                Date lastLastSuccessDate = null;
                Map lastLastSuccessDataMap = null;
                Date lastNextExecuteDate = null;
                Map lastNextExecuteDataMap = null;
                Map anyDataMap = null;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                for (Map.Entry<String, Map> entry : entrySet) {
                    String nextExecuteTimeString;
                    Object nextExecuteTime;
                    String lastSuccessTimeString;
                    Object lastSuccessTime;
                    Map respnoseMap;
                    Object response;
                    Map dapResponseMap = entry.getValue();
                    if (!dapResponseMap.containsKey("response") || !((response = dapResponseMap.get("response")) instanceof Map) || !(respnoseMap = (Map)response).containsKey("data")) continue;
                    Map dataMap = (Map)respnoseMap.get("data");
                    if (anyDataMap == null) {
                        anyDataMap = dataMap;
                    }
                    if ((lastSuccessTime = dataMap.getOrDefault("last_success_time", null)) != null && StringUtils.isNotBlank((CharSequence)(lastSuccessTimeString = String.valueOf(lastSuccessTime)))) {
                        Date date = simpleDateFormat.parse(lastSuccessTimeString);
                        if (lastLastSuccessDate == null) {
                            lastLastSuccessDate = date;
                            lastLastSuccessDataMap = respnoseMap;
                        } else if (date.compareTo(lastLastSuccessDate) > 0) {
                            lastLastSuccessDate = date;
                            lastLastSuccessDataMap = respnoseMap;
                        }
                    }
                    if ((nextExecuteTime = dataMap.getOrDefault("next_execute_time", null)) == null || !StringUtils.isNotBlank((CharSequence)(nextExecuteTimeString = String.valueOf(nextExecuteTime)))) continue;
                    Date date = simpleDateFormat.parse(nextExecuteTimeString);
                    if (lastNextExecuteDate == null) {
                        lastNextExecuteDate = date;
                        lastNextExecuteDataMap = respnoseMap;
                        continue;
                    }
                    if (date.compareTo(lastNextExecuteDate) <= 0) continue;
                    lastNextExecuteDate = date;
                    lastNextExecuteDataMap = respnoseMap;
                }
                if (lastNextExecuteDate != null) {
                    return lastNextExecuteDataMap;
                }
                if (lastLastSuccessDate != null) {
                    return lastLastSuccessDataMap;
                }
                return anyDataMap;
            }
            catch (Exception e) {
                HashMap totalResponseMap = new HashMap();
                HashMap<String, String> masterResponseMap = new HashMap<String, String>();
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] getScheduleInfo message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] getScheduleInfo stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
                return totalResponseMap;
            }
        }
        DWDataRow result = this.scheduleDBService.getScheduleInfo(scheduleId);
        return result;
    }

    public Object getScheduleTimeInfo(String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("getScheduleTimeInfo");
            return response;
        }
        DWDataRow result = this.scheduleTimeDBService.getScheduleTimeInfo(scheduleId);
        return result;
    }

    public Object getScheduleList(DWPagableQueryInfo param) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            String body = DWServiceContext.getContext().getRequestBody();
            if (StringUtils.isBlank((CharSequence)body)) {
                HashSet programCodeSet = new HashSet();
                List programCodeList = (List)DistributedScheduleUtils.redirectDwsysAsAp("getProgramCodeList");
                for (Object programCode : programCodeList) {
                    programCodeSet.add(programCode);
                }
                DWDataSet dataSet = this.mockProgramCodeDataSet(programCodeSet);
                return dataSet;
            }
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("getScheduleList");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            try {
                String body = DWServiceContext.getContext().getRequestBody();
                if (StringUtils.isBlank((CharSequence)body)) {
                    Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("getProgramCodeList");
                    Set<Map.Entry<String, Map>> entrySet = workerResponseMap.entrySet();
                    HashSet programCodeSet = new HashSet();
                    for (Map.Entry<String, Map> entry : entrySet) {
                        Object response;
                        Map dapResponseMap = entry.getValue();
                        if (!dapResponseMap.containsKey("response") || !((response = dapResponseMap.get("response")) instanceof List)) continue;
                        List programCodeList = (List)response;
                        for (Object programCode : programCodeList) {
                            programCodeSet.add(programCode);
                        }
                    }
                    DWDataSet dataSet = this.mockProgramCodeDataSet(programCodeSet);
                    return dataSet;
                }
                Map<String, Map> workerResponseMap = DistributedScheduleUtils.redirectDwsysAsHigherMaster("getScheduleList");
                Set<Map.Entry<String, Map>> entrySet = workerResponseMap.entrySet();
                HashMap<String, DWScheduleElementWrapper> scheduleElementWrapperMap = new HashMap<String, DWScheduleElementWrapper>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                for (Map.Entry<String, Map> entry : entrySet) {
                    Map respnoseMap;
                    Object response;
                    Map dapResponseMap = entry.getValue();
                    if (!dapResponseMap.containsKey("response") || !((response = dapResponseMap.get("response")) instanceof Map) || !(respnoseMap = (Map)response).containsKey("dw_schedule")) continue;
                    List dataList = (List)respnoseMap.get("dw_schedule");
                    for (Map dataMap : dataList) {
                        String nextExecuteTimeString;
                        Object nextExecuteTime;
                        String lastSuccessTimeString;
                        Object lastSuccessTime;
                        String scheduleId = String.valueOf(dataMap.get("schedule_id"));
                        DWScheduleElementWrapper elementWrapper = scheduleElementWrapperMap.getOrDefault(scheduleId, new DWScheduleElementWrapper());
                        if (elementWrapper.getAnyDataMap() == null) {
                            elementWrapper.setAnyDataMap(dataMap);
                        }
                        if ((lastSuccessTime = dataMap.getOrDefault("last_success_time", null)) != null && StringUtils.isNotBlank((CharSequence)(lastSuccessTimeString = String.valueOf(lastSuccessTime)))) {
                            Date date = simpleDateFormat.parse(lastSuccessTimeString);
                            Date lastLastSuccessDate = elementWrapper.getLastLastSuccessDate();
                            if (lastLastSuccessDate == null) {
                                elementWrapper.setLastLastSuccessDate(date);
                                elementWrapper.setLastLastSuccessDataMap(dataMap);
                            } else if (date.compareTo(lastLastSuccessDate) > 0) {
                                elementWrapper.setLastLastSuccessDate(date);
                                elementWrapper.setLastLastSuccessDataMap(dataMap);
                            }
                        }
                        if ((nextExecuteTime = dataMap.getOrDefault("next_execute_time", null)) != null && StringUtils.isNotBlank((CharSequence)(nextExecuteTimeString = String.valueOf(nextExecuteTime)))) {
                            Date date = simpleDateFormat.parse(nextExecuteTimeString);
                            Date lastNextExecuteDate = elementWrapper.getLastLastSuccessDate();
                            if (lastNextExecuteDate == null) {
                                elementWrapper.setLastNextExecuteDate(lastNextExecuteDate);
                                elementWrapper.setLastNextExecuteDataMap(dataMap);
                            } else if (date.compareTo(lastNextExecuteDate) > 0) {
                                elementWrapper.setLastNextExecuteDate(lastNextExecuteDate);
                                elementWrapper.setLastNextExecuteDataMap(dataMap);
                            }
                        }
                        scheduleElementWrapperMap.put(scheduleId, elementWrapper);
                    }
                }
                HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
                Set scheduleElementWrapperMapEntrySet = scheduleElementWrapperMap.entrySet();
                for (Map.Entry entry : scheduleElementWrapperMapEntrySet) {
                    String key = (String)entry.getKey();
                    DWScheduleElementWrapper value = (DWScheduleElementWrapper)entry.getValue();
                    Date lastNextExecuteDate = value.getLastNextExecuteDate();
                    if (lastNextExecuteDate != null) {
                        Map lastNextExecuteDataMap = value.getLastNextExecuteDataMap();
                        totalResponseMap.put(key, lastNextExecuteDataMap);
                        continue;
                    }
                    Date lastLastSuccessDate = value.getLastLastSuccessDate();
                    if (lastLastSuccessDate != null) {
                        Map lastLastSuccessDataMap = value.getLastLastSuccessDataMap();
                        totalResponseMap.put(key, lastLastSuccessDataMap);
                    }
                    totalResponseMap.put(key, value.getAnyDataMap());
                }
                return totalResponseMap;
            }
            catch (Exception e) {
                HashMap totalResponseMap = new HashMap();
                HashMap<String, String> masterResponseMap = new HashMap<String, String>();
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] getScheduleList message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] getScheduleList stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
                return totalResponseMap;
            }
        }
        Object result = this.scheduleDBService.getScheduleList(param);
        return result;
    }

    public Object getScheduleRecordList(DWPagableQueryInfo param) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("getResultList");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            throw new UnsupportedOperationException();
        }
        Object result = this.scheduleRecordDBService.getResultList(param);
        return result;
    }

    public Object getScheduleRecordInfo(DWPagableQueryInfo param) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("getResult");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            throw new UnsupportedOperationException();
        }
        Object result = this.scheduleRecordDBService.getResult(param);
        return result;
    }

    public Object getAvailableJobList() throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            throw new UnsupportedOperationException();
        }
        Object result = this.jobService.getAvailableJobList();
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object recover(String workerId, String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isAp()) {
            Object response = DistributedScheduleUtils.redirectDwsysAsAp("recover");
            return response;
        }
        if (DistributedScheduleUtils.isHigherMaster()) {
            HashMap<String, Map> totalResponseMap = new HashMap<String, Map>();
            HashMap<String, Object> masterResponseMap = new HashMap<String, Object>();
            String body = null;
            try {
                HashMap paramMap = new HashMap();
                DWDataRow scheduleInfoDataRow = this.scheduleDBService.getScheduleInfo(scheduleId);
                if (scheduleInfoDataRow == null) {
                    throw new DWException("no scheduleId: " + scheduleId);
                }
                Map scheduleInfoSourceMap = scheduleInfoDataRow.getDWDataSet().getSourceMap();
                Map scheduleInfoMap = (Map)((List)scheduleInfoSourceMap.get("dw_schedule")).get(0);
                paramMap.putAll(scheduleInfoMap);
                DWDataRow scheduleTimeDataRow = this.scheduleTimeDBService.getScheduleTimeInfo(scheduleId);
                Map scheduleTimeSourceMap = scheduleTimeDataRow.getDWDataSet().getSourceMap();
                Map scheduleTimeMap = (Map)((List)scheduleTimeSourceMap.get("dw_schedule_time")).get(0);
                paramMap.putAll(scheduleTimeMap);
                ArrayList contactList = new ArrayList();
                List scheduleContactList = (List)this.scheduleContactDBService.queryScheduleContactList(scheduleId);
                for (Map scheduleContact : scheduleContactList) {
                    Set entrySet = scheduleContact.entrySet();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if ("id".equals(key)) continue;
                        try {
                            hashMap.put(key, String.valueOf(value));
                        }
                        catch (Exception ignore) {
                            hashMap.put(key, (String)value);
                        }
                    }
                    contactList.add(hashMap);
                }
                paramMap.put("contact_list", contactList);
                Set entrySet = paramMap.entrySet();
                HashMap<String, String> newParamMap = new HashMap<String, String>();
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null || "contact_list".equals(key)) continue;
                    try {
                        newParamMap.put(key, String.valueOf(value));
                    }
                    catch (Exception ignore) {
                        newParamMap.put(key, (String)value);
                    }
                }
                HashMap<String, HashMap<String, String>> bodyMap = new HashMap<String, HashMap<String, String>>();
                bodyMap.put("paramMap", newParamMap);
                JSONObject jSONObject = new JSONObject(bodyMap);
                body = jSONObject.toString().replace("\\\"", "\"");
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] recover message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] recover stack trace: " + stackTrace));
                throw e;
            }
            try {
                Map workerResponse = DistributedScheduleUtils.recoverWorkerData(workerId, body);
                masterResponseMap.put("response", true);
                totalResponseMap.put("master", masterResponseMap);
                totalResponseMap.put(workerId, workerResponse);
            }
            catch (Exception e) {
                String stackTrace = DistributedScheduleUtils.getStackTrace(e);
                this.log.error((Object)("[DWSchedule.DWScheduleContext] recover message: " + e.getMessage()));
                this.log.error((Object)("[DWSchedule.DWScheduleContext] recover stack trace: " + stackTrace));
                masterResponseMap.put("response", stackTrace);
                totalResponseMap.put("master", masterResponseMap);
            }
            return totalResponseMap;
        }
        throw new UnsupportedOperationException();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object recoverWorkerData(DWScheduleQuartzInfo quartzInfo) throws Exception {
        if (!DistributedScheduleUtils.isWorker()) {
            throw new UnsupportedOperationException();
        }
        try {
            String scheduleId = quartzInfo.getScheduleId();
            this.scheduleService.deleteJob(scheduleId);
            this.scheduleDBService.deleteSchedule(scheduleId);
            this.scheduleTimeDBService.deleteScheduleTime(scheduleId);
            this.scheduleContactDBService.deleteScheduleContact(scheduleId);
            this.addSchedule(quartzInfo);
            return true;
        }
        catch (Exception e) {
            String stackTrace = DistributedScheduleUtils.getStackTrace(e);
            this.log.error((Object)("[DWSchedule.DWScheduleContext] recover message: " + e.getMessage()));
            this.log.error((Object)("[DWSchedule.DWScheduleContext] recover stack trace: " + stackTrace));
            throw e;
        }
    }

    private DWDataSet mockProgramCodeDataSet(Set programCodeSet) throws Exception {
        DWDataSet dataSet = new DWDataSet();
        DWDataTableCollection tables = new DWDataTableCollection();
        Field dataSetField = DWDataTableCollection.class.getDeclaredField("dataSet");
        dataSetField.setAccessible(true);
        dataSetField.set(tables, dataSet);
        DWDataTable table = new DWDataTable("dw_schedule");
        Field ownerField = DWDataTable.class.getDeclaredField("owner");
        ownerField.setAccessible(true);
        ownerField.set(table, tables);
        for (Object programCode : programCodeSet) {
            HashMap orgData = new HashMap();
            orgData.put("program_code", programCode);
            table.newRow(orgData);
        }
        ConcurrentHashMap<String, DWDataTable> tablesMap = new ConcurrentHashMap<String, DWDataTable>();
        tablesMap.put("dw_schedule", table);
        Field tablesField = DWDataTableCollection.class.getDeclaredField("tables");
        tablesField.setAccessible(true);
        tablesField.set(tables, tablesMap);
        Field dataSetTablesField = DWDataSet.class.getDeclaredField("tables");
        dataSetTablesField.setAccessible(true);
        dataSetTablesField.set(dataSet, tables);
        return dataSet;
    }

    private class DWScheduleElementWrapper {
        private Date lastLastSuccessDate = null;
        private Map lastLastSuccessDataMap = null;
        private Date lastNextExecuteDate = null;
        private Map lastNextExecuteDataMap = null;
        private Map anyDataMap = null;

        private DWScheduleElementWrapper() {
        }

        public Date getLastLastSuccessDate() {
            return this.lastLastSuccessDate;
        }

        public void setLastLastSuccessDate(Date lastLastSuccessDate) {
            this.lastLastSuccessDate = lastLastSuccessDate;
        }

        public Map getLastLastSuccessDataMap() {
            return this.lastLastSuccessDataMap;
        }

        public void setLastLastSuccessDataMap(Map lastLastSuccessDataMap) {
            this.lastLastSuccessDataMap = lastLastSuccessDataMap;
        }

        public Date getLastNextExecuteDate() {
            return this.lastNextExecuteDate;
        }

        public void setLastNextExecuteDate(Date lastNextExecuteDate) {
            this.lastNextExecuteDate = lastNextExecuteDate;
        }

        public Map getLastNextExecuteDataMap() {
            return this.lastNextExecuteDataMap;
        }

        public void setLastNextExecuteDataMap(Map lastNextExecuteDataMap) {
            this.lastNextExecuteDataMap = lastNextExecuteDataMap;
        }

        public Map getAnyDataMap() {
            return this.anyDataMap;
        }

        public void setAnyDataMap(Map anyDataMap) {
            this.anyDataMap = anyDataMap;
        }
    }
}

