/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.schedule.exception.DistributedScheduleException;
import com.digiwin.app.schedule.util.DWScheduleHttpClient;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class DistributedScheduleUtils {
    private static final String CLASS_TAG = "[DWSchedule.DistributedScheduleUtils]";
    private static Log log = LogFactory.getLog(DistributedScheduleUtils.class);

    public static boolean isSimpleMaster() {
        boolean distributedScheduleEnable = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleEnable", (String)"false"));
        boolean distributedScheduleSimpleMaster = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleSimpleMaster", (String)"false"));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isSimpleMaster: " + (distributedScheduleEnable && distributedScheduleSimpleMaster)));
        return distributedScheduleEnable && distributedScheduleSimpleMaster;
    }

    public static boolean isHigherMaster() {
        boolean distributedScheduleEnable = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleEnable", (String)"false"));
        boolean distributedScheduleHigherMaster = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleHigherMaster", (String)"false"));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isHigherMaster: " + (distributedScheduleEnable && distributedScheduleHigherMaster)));
        return distributedScheduleEnable && distributedScheduleHigherMaster;
    }

    public static boolean isMaster() {
        boolean isSimpleMaster = DistributedScheduleUtils.isSimpleMaster();
        boolean isHigherMaster = DistributedScheduleUtils.isHigherMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isMaster: " + (isSimpleMaster || isHigherMaster)));
        return isSimpleMaster || isHigherMaster;
    }

    public static boolean isWorker() {
        boolean distributedScheduleEnable = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleEnable", (String)"false"));
        boolean distributedScheduleWorker = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorker", (String)"false"));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isWorker: " + (distributedScheduleEnable && distributedScheduleWorker)));
        return distributedScheduleEnable && distributedScheduleWorker;
    }

    public static boolean isAp() {
        boolean distributedScheduleEnable = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"distributedScheduleEnable", (String)"false"));
        boolean isMaster = DistributedScheduleUtils.isMaster();
        boolean isWorker = DistributedScheduleUtils.isWorker();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isAp: " + (distributedScheduleEnable && !isMaster && !isWorker)));
        return distributedScheduleEnable && !isMaster && !isWorker;
    }

    public static boolean isRedirectDwsys() {
        boolean isAp = DistributedScheduleUtils.isAp();
        boolean isHigherMaster = DistributedScheduleUtils.isHigherMaster();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isRedirectDwsys: " + (isAp || isHigherMaster)));
        return isAp || isHigherMaster;
    }

    public static boolean isRedirectSchedule() {
        boolean isSimpleMaster = DistributedScheduleUtils.isSimpleMaster();
        boolean isWorker = DistributedScheduleUtils.isWorker();
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isRedirectSchedule: " + (isSimpleMaster || isWorker)));
        return isSimpleMaster || isWorker;
    }

    public static boolean isExecuteWorker(String key) {
        int serialNumber;
        int totalWorker = DistributedScheduleUtils.getTotalWorker();
        int dwHash = DistributedScheduleUtils.getDWHash(key);
        int toWorker = dwHash % totalWorker;
        boolean isExecuteWorker = toWorker == (serialNumber = DistributedScheduleUtils.getSerialNumber());
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] totalWorker: " + totalWorker));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] dwHash: " + dwHash));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] toWorker: " + toWorker));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] serialNumber: " + serialNumber));
        log.debug((Object)("[DWSchedule.DistributedScheduleUtils] isExecuteWorker: " + (toWorker == serialNumber)));
        return isExecuteWorker;
    }

    public static int getDWHash(String key) {
        int sumOfdigits = DistributedScheduleUtils.sumOfdigits(String.valueOf(key.hashCode()));
        int dwHash = sumOfdigits + 3000;
        return dwHash;
    }

    private static int sumOfdigits(String number) {
        int sum = 0;
        for (int i = 0; i < number.length(); ++i) {
            char ch = number.charAt(i);
            if (!Character.isDigit(ch)) continue;
            int n = Character.getNumericValue(ch);
            sum += n;
        }
        return sum;
    }

    public static int getTotalWorker() {
        String distributedScheduleWorkerUrl = DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerUrl", null);
        if (StringUtils.isBlank((CharSequence)distributedScheduleWorkerUrl)) {
            log.debug((Object)"[DWSchedule.DistributedScheduleUtils] no distributedScheduleWorkerUrl default 1");
            return 1;
        }
        List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
        int totalWorker = mappingList.size();
        return totalWorker;
    }

    public static int getSerialNumber() {
        String targetWorkerId = DistributedScheduleUtils.getWorkerId();
        String distributedScheduleWorkerUrl = DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerUrl", null);
        if (StringUtils.isNotBlank((CharSequence)targetWorkerId) && StringUtils.isNotBlank((CharSequence)distributedScheduleWorkerUrl)) {
            List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
            for (int i = 0; i < mappingList.size(); ++i) {
                String mapping = mappingList.get(i);
                String[] mappingParts = mapping.split("::");
                String workerId = mappingParts[0];
                if (!targetWorkerId.equals(workerId)) continue;
                return i;
            }
        }
        log.debug((Object)"[DWSchedule.DistributedScheduleUtils] no targetWorkerId or distributedScheduleWorkerUrl default 0");
        return 0;
    }

    public static String getWorkerId() {
        String workerId = DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerId", null);
        return workerId;
    }

    public static Object redirectDwsysAsAp(String methodName) throws Exception {
        log.info((Object)("[DWSchedule.DistributedScheduleUtils] " + methodName + ": redirectDwsysAsAp"));
        String url = DWApplicationConfigUtils.getProperty((String)"distributedScheduleMasterUrl", null);
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new DWBusinessException("no distributedScheduleMasterUrl");
        }
        url = url + "/restful/service/DWSys/IScheduleService/" + methodName;
        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity httpEntity = httpResponse.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
        Map responseMap = new HashMap();
        try {
            Gson gson = DWGsonProvider.getGson();
            responseMap = (Map)gson.fromJson(responseBody, Map.class);
        }
        catch (Exception e) {
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] response body: " + responseBody));
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            String message = ExceptionUtils.getMessage((Throwable)rootCause);
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
            log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
            throw new DWException("response body: " + responseBody, (Throwable)e);
        }
        if (statusCode == 200) {
            long duration = Double.valueOf(String.valueOf(responseMap.getOrDefault("duration", 0))).longValue();
            DWServiceContext.getContext().pushDuration(duration);
            Object response = responseMap.get("response");
            return response;
        }
        DistributedScheduleException exception = new DistributedScheduleException();
        Map debugInfoMap = responseMap.getOrDefault("debugInfo", new HashMap());
        String stackTrace = debugInfoMap.getOrDefault("stackTrace", "");
        exception.setStatusCode(statusCode);
        exception.setRemoteStackTrace(stackTrace);
        exception.setSourceId("Master");
        throw exception;
    }

    public static Map<String, Map> redirectDwsysAsHigherMaster(String methodName) throws Exception {
        log.info((Object)("[DWSchedule.DistributedScheduleUtils] " + methodName + ": redirectDwsysAsHigherMaster"));
        String distributedScheduleWorkerUrl = DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerUrl");
        if (StringUtils.isBlank((CharSequence)distributedScheduleWorkerUrl)) {
            throw new DWBusinessException("no distributedScheduleWorkerUrl");
        }
        List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
        for (String string : mappingList) {
            String[] mappingParts = string.split("::");
            if (mappingParts.length != 2) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl pattern");
            }
            String targetWorkerId = mappingParts[0];
            String targetUrl = mappingParts[1];
            if (StringUtils.isBlank((CharSequence)targetWorkerId)) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl WorkerId");
            }
            if (!StringUtils.isBlank((CharSequence)targetUrl)) continue;
            throw new DWBusinessException("check distributedScheduleWorkerUrl " + targetWorkerId + " url");
        }
        final ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(mappingList.size());
        for (String mapping : mappingList) {
            String[] mappingParts = mapping.split("::");
            final String targetWorkerId = mappingParts[0];
            String targetUrl = mappingParts[1];
            final String url = targetUrl = targetUrl + "/restful/service/DWSys/IScheduleService/" + methodName;
            final DWServiceContext finalContext = DWServiceContext.getContext();
            Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    DWServiceContext.setContext((DWServiceContext)finalContext);
                    try {
                        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url);
                        HttpEntity httpEntity = httpResponse.getEntity();
                        String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
                        Map responseBodyMap = new HashMap();
                        Gson gson = DWGsonProvider.getGson();
                        responseBodyMap = (Map)gson.fromJson(responseBody, Map.class);
                        WorkerResponseWrapper workerResponseWrapper = new WorkerResponseWrapper(targetWorkerId, responseBodyMap);
                        responseQueue.add(workerResponseWrapper);
                    }
                    catch (Throwable e) {
                        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                        String message = ExceptionUtils.getMessage((Throwable)rootCause);
                        String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
                        log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
                        log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
                        HashMap<String, String> responseBodyMap = new HashMap<String, String>();
                        responseBodyMap.put("response", stackTrace);
                        WorkerResponseWrapper workerResponseWrapper = new WorkerResponseWrapper(targetWorkerId, responseBodyMap);
                        responseQueue.add(workerResponseWrapper);
                        return false;
                    }
                    return true;
                }
            });
        }
        while (responseQueue.remainingCapacity() != 0) {
        }
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        responseQueue.forEach(workerResponseWrapper -> {
            String workerId = ((WorkerResponseWrapper)workerResponseWrapper).getWorkerId();
            Map response = ((WorkerResponseWrapper)workerResponseWrapper).getResponse();
            workerResponseMap.put(workerId, response);
        });
        return hashMap;
    }

    public static Map recoverWorkerData(String workerId, String body) throws Exception {
        String targetUrl;
        String targetWorkerId;
        String[] mappingParts;
        String distributedScheduleWorkerUrl = DWApplicationConfigUtils.getProperty((String)"distributedScheduleWorkerUrl");
        if (StringUtils.isBlank((CharSequence)distributedScheduleWorkerUrl)) {
            throw new DWBusinessException("no distributedScheduleWorkerUrl");
        }
        List<String> mappingList = Arrays.asList(distributedScheduleWorkerUrl.split(","));
        for (String mapping : mappingList) {
            mappingParts = mapping.split("::");
            if (mappingParts.length != 2) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl pattern");
            }
            targetWorkerId = mappingParts[0];
            targetUrl = mappingParts[1];
            if (StringUtils.isBlank((CharSequence)targetWorkerId)) {
                throw new DWBusinessException("check distributedScheduleWorkerUrl WorkerId");
            }
            if (!StringUtils.isBlank((CharSequence)targetUrl)) continue;
            throw new DWBusinessException("check distributedScheduleWorkerUrl " + targetWorkerId + " url");
        }
        for (String mapping : mappingList) {
            mappingParts = mapping.split("::");
            targetWorkerId = mappingParts[0];
            if (!targetWorkerId.equals(workerId)) continue;
            targetUrl = mappingParts[1];
            targetUrl = targetUrl + "/restful/service/DWSys/IScheduleService/recoverWorkerData";
            CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(targetUrl, body);
            HttpEntity httpEntity = httpResponse.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            Map responseMap = new HashMap();
            try {
                Gson gson = DWGsonProvider.getGson();
                responseMap = (Map)gson.fromJson(responseBody, Map.class);
            }
            catch (Exception e) {
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] response body: " + responseBody));
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                String message = ExceptionUtils.getMessage((Throwable)rootCause);
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)rootCause);
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] message: " + message));
                log.error((Object)("[DWSchedule.DistributedScheduleUtils] stack trace: " + stackTrace));
                throw new DWException("response body: " + responseBody, (Throwable)e);
            }
            return responseMap;
        }
        throw new DWException("no " + workerId);
    }

    private static CloseableHttpResponse redirect(String url) throws Exception {
        String body = DWServiceContext.getContext().getRequestBody();
        CloseableHttpResponse httpResponse = DistributedScheduleUtils.redirect(url, body);
        return httpResponse;
    }

    private static CloseableHttpResponse redirect(String url, String body) throws Exception {
        CloseableHttpClient httpclient = DWScheduleHttpClient.get();
        String token = DWServiceContext.getContext().getToken();
        String tenantId = (String)DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIamTenantIdKey());
        StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)stringEntity);
        httpPost.addHeader("token", token);
        httpPost.addHeader("routerKey", tenantId);
        long threadId = Thread.currentThread().getId();
        log.info((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect request{%s}>routerKey=%s, url=%s", threadId, tenantId, url));
        log.debug((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect request{%s}>body=%s", threadId, body));
        CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        log.info((Object)String.format("[DWSchedule.DistributedScheduleUtils]>redirect result{%s}>status=%s", threadId, statusCode));
        return httpResponse;
    }

    private static class WorkerResponseWrapper {
        private String workerId;
        private Map response;

        private WorkerResponseWrapper(String workerId, Map response) {
            this.workerId = workerId;
            this.response = response;
        }

        private String getWorkerId() {
            return this.workerId;
        }

        private Map getResponse() {
            return this.response;
        }
    }
}

