/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.config;

import com.digiwin.app.schedule.config.condifion.SubPublishCondition;
import com.digiwin.app.schedule.quartz.listener.WorkerKeyExpirationListener;
import com.digiwin.app.schedule.quartz.listener.WorkerOnlineReceiver;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
public class DWScheduleAutoConfiguration {
    @Bean(name={"dwRedisMessageListenerContainer"})
    @Conditional(value={SubPublishCondition.class})
    RedisMessageListenerContainer container(RedisConnectionFactory redisConnectionFactory, MessageListenerAdapter listenerAdapter, WorkerKeyExpirationListener workerKeyExpirationListener) throws Exception {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("onlineWorkers"));
        List<String> workIds = DistributedScheduleUtils.getAllWorkerIds();
        workIds.forEach(item -> container.addMessageListener((MessageListener)workerKeyExpirationListener, (Topic)new PatternTopic("__keyspace@0__:DWQuartz::worker::" + item)));
        return container;
    }

    @Bean
    @Conditional(value={SubPublishCondition.class})
    MessageListenerAdapter listenerAdapter() {
        return new MessageListenerAdapter((Object)new WorkerOnlineReceiver(), "receiveMessage");
    }

    @Bean
    @Conditional(value={SubPublishCondition.class})
    WorkerKeyExpirationListener workerKeyExpirationListener() {
        return new WorkerKeyExpirationListener();
    }
}

